/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.tofu.internal;

import com.google.common.base.Preconditions;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.parseinfo.SoyTemplateInfo;
import com.google.template.soy.tofu.SoyTofu;
import com.google.template.soy.tofu.internal.BaseTofu;
import java.util.Map;
import javax.annotation.Nullable;

class NamespacedTofu
implements SoyTofu {
    private final BaseTofu baseTofu;
    private final String namespace;

    NamespacedTofu(BaseTofu baseTofu, String string) {
        Preconditions.checkNotNull((Object)baseTofu);
        this.baseTofu = baseTofu;
        Preconditions.checkArgument((string != null && string.length() > 0 ? 1 : 0) != 0);
        this.namespace = string;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public SoyTofu forNamespace(@Nullable String string) {
        return string == null ? this.baseTofu : new NamespacedTofu(this.baseTofu, string);
    }

    @Override
    public String render(SoyTemplateInfo soyTemplateInfo, @Nullable Map<String, ?> map, @Nullable SoyMsgBundle soyMsgBundle) {
        return this.render(soyTemplateInfo.getPartialName(), map, soyMsgBundle);
    }

    @Override
    public String render(SoyTemplateInfo soyTemplateInfo, @Nullable SoyMapData soyMapData, @Nullable SoyMsgBundle soyMsgBundle) {
        return this.render(soyTemplateInfo.getPartialName(), soyMapData, soyMsgBundle);
    }

    @Override
    public String render(String string, @Nullable Map<String, ?> map, @Nullable SoyMsgBundle soyMsgBundle) {
        return this.render(string, map == null ? null : new SoyMapData(map), soyMsgBundle);
    }

    @Override
    public String render(String string, @Nullable SoyMapData soyMapData, @Nullable SoyMsgBundle soyMsgBundle) {
        Preconditions.checkArgument((string.charAt(0) == '.' ? 1 : 0) != 0);
        return this.baseTofu.render(this.namespace + string, soyMapData, soyMsgBundle);
    }
}

