/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentSoyCommandNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;

public class SwitchNode
extends AbstractParentSoyCommandNode<SoyNode>
implements SoyNode.SplitLevelTopNode<SoyNode>,
SoyNode.SoyStatementNode,
SoyNode.ParentExprHolderNode<SoyNode> {
    private final String exprText;
    private final ExprRootNode<ExprNode> expr;

    public SwitchNode(String string, String string2) throws SoySyntaxException {
        super(string, "switch", string2);
        this.exprText = string2;
        ExprRootNode<ExprNode> exprRootNode = null;
        try {
            exprRootNode = new ExpressionParser(this.exprText).parseExpression();
        }
        catch (TokenMgrError tokenMgrError) {
            throw this.createExceptionForInvalidExpr(tokenMgrError);
        }
        catch (ParseException parseException) {
            throw this.createExceptionForInvalidExpr(parseException);
        }
        this.expr = exprRootNode;
    }

    private SoySyntaxException createExceptionForInvalidExpr(Throwable throwable) {
        return new SoySyntaxException("Invalid expression in 'switch' command text \"" + this.getCommandText() + "\".", throwable);
    }

    public String getExprText() {
        return this.exprText;
    }

    public ExprRootNode<ExprNode> getExpr() {
        return this.expr;
    }

    @Override
    public List<? extends ExprRootNode<? extends ExprNode>> getAllExprs() {
        return ImmutableList.of(this.expr);
    }
}

