/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import javax.annotation.Nullable;

public class SoytreeUtils {
    public static SoySyntaxException createSoySyntaxExceptionWithMetaInfo(@Nullable String string, @Nullable Throwable throwable, SoyNode soyNode) {
        SoyFileNode soyFileNode;
        SoySyntaxException soySyntaxException;
        if (string != null && throwable != null) {
            soySyntaxException = new SoySyntaxException(string, throwable);
        } else if (string != null) {
            soySyntaxException = new SoySyntaxException(string);
        } else if (throwable != null) {
            soySyntaxException = new SoySyntaxException(throwable);
        } else {
            throw new AssertionError();
        }
        TemplateNode templateNode = soyNode.getNearestAncestor(TemplateNode.class);
        if (templateNode != null) {
            soySyntaxException.setTemplateName(templateNode.getTemplateName());
        }
        if ((soyFileNode = soyNode.getNearestAncestor(SoyFileNode.class)) != null) {
            soySyntaxException.setFilePath(soyFileNode.getFilePath());
        }
        return soySyntaxException;
    }

    public static void visitAllExprs(SoyFileSetNode soyFileSetNode, AbstractExprNodeVisitor<Void> abstractExprNodeVisitor) {
        new VisitAllExprsVisitor(abstractExprNodeVisitor).exec(soyFileSetNode);
    }

    private static class VisitAllExprsVisitor
    extends AbstractSoyNodeVisitor<Void> {
        private final AbstractExprNodeVisitor<Void> exprNodeVisitor;

        public VisitAllExprsVisitor(AbstractExprNodeVisitor<Void> abstractExprNodeVisitor) {
            this.exprNodeVisitor = abstractExprNodeVisitor;
        }

        @Override
        protected void visitInternal(SoyNode soyNode) {
        }

        @Override
        protected void visitInternal(SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode) {
            this.visitChildren(parentSoyNode);
        }

        @Override
        protected void visitInternal(SoyNode.ExprHolderNode exprHolderNode) {
            this.visitExprs(exprHolderNode);
        }

        @Override
        protected void visitInternal(SoyNode.ParentExprHolderNode<? extends SoyNode> parentExprHolderNode) {
            this.visitChildren(parentExprHolderNode);
            this.visitExprs(parentExprHolderNode);
        }

        private void visitExprs(SoyNode.ExprHolderNode exprHolderNode) {
            for (ExprRootNode<? extends ExprNode> exprRootNode : exprHolderNode.getAllExprs()) {
                try {
                    this.exprNodeVisitor.exec(exprRootNode);
                }
                catch (SoySyntaxException soySyntaxException) {
                    throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo(soySyntaxException.getMessage(), soySyntaxException.getCause(), exprHolderNode);
                }
            }
        }
    }
}

