/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.CharMatcher;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import javax.annotation.Nullable;

public class SoyFileNode
extends AbstractParentSoyNode<TemplateNode>
implements SoyNode.SplitLevelTopNode<TemplateNode> {
    private final String namespace;
    private String filePath;
    private String fileName;

    public SoyFileNode(String string, @Nullable String string2) throws SoySyntaxException {
        super(string);
        this.namespace = string2;
        if (string2 == null) {
            this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
        } else if (!BaseUtils.isDottedIdentifier(string2)) {
            throw new SoySyntaxException("Invalid namespace \"" + string2 + "\".");
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setFilePath(String string) {
        int n = string.lastIndexOf(33);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        this.filePath = string;
        int n2 = CharMatcher.anyOf((CharSequence)"/\\").lastIndexIn((CharSequence)string);
        this.fileName = n2 != -1 && n2 != string.length() - 1 ? string.substring(n2 + 1) : string;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String toSourceString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.namespace != null) {
            stringBuilder.append("{namespace ").append(this.namespace).append("}\n");
        }
        for (TemplateNode templateNode : this.getChildren()) {
            stringBuilder.append("\n");
            stringBuilder.append(templateNode.toSourceString());
        }
        return stringBuilder.toString();
    }
}

