/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.DataRefKeyNode;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.soytree.AbstractParentSoyCommandNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.Collections;
import java.util.List;

public class PrintNode
extends AbstractParentSoyCommandNode<PrintDirectiveNode>
implements SoyNode.SplitLevelTopNode<PrintDirectiveNode>,
SoyNode.SoyStatementNode,
SoyNode.ParentExprHolderNode<PrintDirectiveNode>,
SoyNode.MsgPlaceholderNode {
    private final String exprText;
    private final ExprRootNode<ExprNode> expr;
    private String basePlaceholderName = null;

    public PrintNode(String string, String string2, String string3) throws SoySyntaxException {
        super(string, "print", string2);
        this.exprText = string3;
        ExprRootNode<ExprNode> exprRootNode = null;
        try {
            exprRootNode = new ExpressionParser(string3).parseExpression();
        }
        catch (TokenMgrError tokenMgrError) {
            this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
        }
        catch (ParseException parseException) {
            this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
        }
        this.expr = exprRootNode;
    }

    public String getExprText() {
        return this.exprText;
    }

    public ExprRootNode<ExprNode> getExpr() {
        return this.expr;
    }

    @Override
    public String genBasePlaceholderName() {
        ExprNode exprNode;
        if (this.basePlaceholderName != null) {
            return this.basePlaceholderName;
        }
        AbstractParentExprNode abstractParentExprNode = null;
        try {
            abstractParentExprNode = (DataRefNode)new ExpressionParser(this.exprText).parseDataReference().getChild(0);
        }
        catch (TokenMgrError tokenMgrError) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (abstractParentExprNode != null && (exprNode = abstractParentExprNode.getChild(abstractParentExprNode.numChildren() - 1)) instanceof DataRefKeyNode) {
            String string = ((DataRefKeyNode)exprNode).getKey();
            this.basePlaceholderName = BaseUtils.convertToUpperUnderscore(string);
        }
        if (this.basePlaceholderName == null) {
            exprNode = null;
            try {
                exprNode = (GlobalNode)new ExpressionParser(this.exprText).parseGlobal().getChild(0);
            }
            catch (TokenMgrError tokenMgrError) {
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (exprNode != null) {
                int n = ((GlobalNode)exprNode).getName().lastIndexOf(46);
                String string = ((GlobalNode)exprNode).getName().substring(n + 1);
                this.basePlaceholderName = BaseUtils.convertToUpperUnderscore(string);
            }
        }
        if (this.basePlaceholderName == null) {
            this.basePlaceholderName = "XXX";
        }
        return this.basePlaceholderName;
    }

    @Override
    public boolean isSamePlaceholderAs(SoyNode.MsgPlaceholderNode msgPlaceholderNode) {
        return msgPlaceholderNode instanceof PrintNode && this.getCommandText().equals(((PrintNode)msgPlaceholderNode).getCommandText());
    }

    @Override
    public List<? extends ExprRootNode<? extends ExprNode>> getAllExprs() {
        return this.expr != null ? ImmutableList.of(this.expr) : Collections.emptyList();
    }

    @Override
    public String toSourceString() {
        return this.getTagString();
    }
}

