/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.AbstractParentSoyCommandNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.SoyNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MsgNode
extends AbstractParentSoyCommandNode<SoyNode>
implements SoyNode.SoyStatementNode {
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("msg", new CommandTextAttributesParser.Attribute("meaning", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("desc", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, "__NDVBR__"), new CommandTextAttributesParser.Attribute("hidden", CommandTextAttributesParser.Attribute.BOOLEAN_VALUES, "false"));
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private final String meaning;
    private final String desc;
    private final boolean isHidden;
    private Map<String, SoyNode.MsgPlaceholderNode> phNameToRepNodeMap = null;
    private Map<SoyNode.MsgPlaceholderNode, String> phNodeToNameMap = null;

    public MsgNode(String string, String string2) throws SoySyntaxException {
        super(string, "msg", string2);
        Map<String, String> map = ATTRIBUTES_PARSER.parse(string2);
        this.meaning = map.get("meaning");
        this.desc = map.get("desc");
        this.isHidden = map.get("hidden").equals("true");
    }

    public String getMeaning() {
        return this.meaning;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public String getContentType() {
        return DEFAULT_CONTENT_TYPE;
    }

    public SoyNode.MsgPlaceholderNode getPlaceholderNode(String string) {
        if (this.phNameToRepNodeMap == null) {
            this.genPlaceholderNamesHelper();
        }
        return this.phNameToRepNodeMap.get(string);
    }

    public String getPlaceholderName(SoyNode.MsgPlaceholderNode msgPlaceholderNode) {
        if (this.phNodeToNameMap == null) {
            this.genPlaceholderNamesHelper();
        }
        return this.phNodeToNameMap.get(msgPlaceholderNode);
    }

    private void genPlaceholderNamesHelper() {
        Object object;
        Object object2;
        HashMap hashMap = Maps.newHashMap();
        HashMap hashMap2 = Maps.newHashMap();
        for (SoyNode object3 : this.getChildren()) {
            if (!(object3 instanceof SoyNode.MsgPlaceholderNode)) continue;
            object2 = (SoyNode.MsgPlaceholderNode)object3;
            object = object2.genBasePlaceholderName();
            if (!hashMap.containsKey(object)) {
                hashMap.put(object, Lists.newArrayList((Object[])new SoyNode.MsgPlaceholderNode[]{object2}));
                continue;
            }
            List list = (List)hashMap.get(object);
            boolean bl = true;
            for (Object object4 : list) {
                if (!object2.isSamePlaceholderAs((SoyNode.MsgPlaceholderNode)object4)) continue;
                hashMap2.put(object2, object4);
                bl = false;
                break;
            }
            if (!bl) continue;
            list.add(object2);
        }
        this.phNameToRepNodeMap = Maps.newHashMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            object2 = (String)entry.getKey();
            object = (List)entry.getValue();
            if (object.size() == 1) {
                this.phNameToRepNodeMap.put((String)object2, (SoyNode.MsgPlaceholderNode)object.get(0));
                continue;
            }
            int n = 1;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object object4;
                SoyNode.MsgPlaceholderNode msgPlaceholderNode = (SoyNode.MsgPlaceholderNode)iterator.next();
                do {
                    object4 = (String)object2 + "_" + n;
                    ++n;
                } while (hashMap.containsKey(object4));
                this.phNameToRepNodeMap.put((String)object4, msgPlaceholderNode);
            }
        }
        this.phNodeToNameMap = Maps.newHashMap();
        for (Map.Entry entry : this.phNameToRepNodeMap.entrySet()) {
            this.phNodeToNameMap.put((SoyNode.MsgPlaceholderNode)entry.getValue(), (String)entry.getKey());
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            this.phNodeToNameMap.put((SoyNode.MsgPlaceholderNode)entry.getKey(), this.phNodeToNameMap.get(entry.getValue()));
        }
    }
}

