/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentSoyCommandNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.Collections;
import java.util.List;

public class IfCondNode
extends AbstractParentSoyCommandNode<SoyNode>
implements SoyNode.ConditionalBlockNode<SoyNode>,
SoyNode.ParentExprHolderNode<SoyNode> {
    private final String exprText;
    private final ExprRootNode<ExprNode> expr;

    public IfCondNode(String string, String string2, String string3) {
        super(string, string2, string3);
        Preconditions.checkArgument((string2.equals("if") || string2.equals("elseif") ? 1 : 0) != 0);
        this.exprText = string3;
        ExprRootNode<ExprNode> exprRootNode = null;
        try {
            exprRootNode = new ExpressionParser(this.exprText).parseExpression();
        }
        catch (TokenMgrError tokenMgrError) {
            this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
        }
        catch (ParseException parseException) {
            this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
        }
        this.expr = exprRootNode;
    }

    public String getExprText() {
        return this.exprText;
    }

    public ExprRootNode<ExprNode> getExpr() {
        return this.expr;
    }

    @Override
    public String toSourceString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTagString());
        this.appendSourceStringForChildren(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public List<? extends ExprRootNode<? extends ExprNode>> getAllExprs() {
        return this.expr != null ? ImmutableList.of(this.expr) : Collections.emptyList();
    }
}

