/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.VarNode;
import com.google.template.soy.soytree.AbstractParentSoyCommandNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ForeachNode
extends AbstractParentSoyCommandNode<SoyNode>
implements SoyNode.SplitLevelTopNode<SoyNode>,
SoyNode.SoyStatementNode,
SoyNode.ParentExprHolderNode<SoyNode> {
    private static final Pattern COMMAND_TEXT_PATTERN = Pattern.compile("( [$] \\w+ ) \\s+ in \\s+ (.*)", 36);
    private final String varName;
    private final String dataRefText;
    private final ExprRootNode<DataRefNode> dataRef;

    public ForeachNode(String string, String string2) throws SoySyntaxException {
        super(string, "foreach", string2);
        Matcher matcher = COMMAND_TEXT_PATTERN.matcher(string2);
        if (!matcher.matches()) {
            throw new SoySyntaxException("Invalid 'foreach' command text \"" + string2 + "\".");
        }
        try {
            this.varName = ((VarNode)new ExpressionParser(matcher.group(1)).parseVariable().getChild(0)).getName();
        }
        catch (TokenMgrError tokenMgrError) {
            throw this.createExceptionForInvalidCommandText("variable name", tokenMgrError);
        }
        catch (ParseException parseException) {
            throw this.createExceptionForInvalidCommandText("variable name", parseException);
        }
        this.dataRefText = matcher.group(2);
        try {
            this.dataRef = new ExpressionParser(this.dataRefText).parseDataReference();
        }
        catch (TokenMgrError tokenMgrError) {
            throw this.createExceptionForInvalidCommandText("data reference", tokenMgrError);
        }
        catch (ParseException parseException) {
            throw this.createExceptionForInvalidCommandText("data reference", parseException);
        }
    }

    private SoySyntaxException createExceptionForInvalidCommandText(String string, Throwable throwable) {
        return new SoySyntaxException("Invalid " + string + " in 'foreach' command text \"" + this.getCommandText() + "\".", throwable);
    }

    public String getVarName() {
        return this.varName;
    }

    public String getDataRefText() {
        return this.dataRefText;
    }

    public ExprRootNode<DataRefNode> getDataRef() {
        return this.dataRef;
    }

    @Override
    public List<? extends ExprRootNode<? extends ExprNode>> getAllExprs() {
        return ImmutableList.of(this.dataRef);
    }
}

