/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.Lists;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.VarNode;
import com.google.template.soy.soytree.AbstractParentSoyCommandNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ForNode
extends AbstractParentSoyCommandNode<SoyNode>
implements SoyNode.SoyStatementNode,
SoyNode.ConditionalBlockNode<SoyNode>,
SoyNode.LoopNode<SoyNode>,
SoyNode.ParentExprHolderNode<SoyNode>,
SoyNode.LocalVarBlockNode<SoyNode> {
    private static final Pattern COMMAND_TEXT_PATTERN = Pattern.compile("( [$] \\w+ ) \\s+ in \\s+ range[(] \\s* (.*) \\s* [)]", 36);
    private final String localVarName;
    private final List<String> rangeArgTexts;
    private final List<ExprRootNode<ExprNode>> rangeArgs;

    public ForNode(String string, String string2) throws SoySyntaxException {
        super(string, "for", string2);
        Matcher matcher = COMMAND_TEXT_PATTERN.matcher(string2);
        if (!matcher.matches()) {
            throw new SoySyntaxException("Invalid 'for' command text \"" + string2 + "\".");
        }
        try {
            this.localVarName = ((VarNode)new ExpressionParser(matcher.group(1)).parseVariable().getChild(0)).getName();
        }
        catch (TokenMgrError tokenMgrError) {
            throw this.createExceptionForInvalidCommandText("variable name", tokenMgrError);
        }
        catch (ParseException parseException) {
            throw this.createExceptionForInvalidCommandText("variable name", parseException);
        }
        try {
            this.rangeArgs = new ExpressionParser(matcher.group(2)).parseExpressionList();
        }
        catch (TokenMgrError tokenMgrError) {
            throw this.createExceptionForInvalidCommandText("range specification", tokenMgrError);
        }
        catch (ParseException parseException) {
            throw this.createExceptionForInvalidCommandText("range specification", parseException);
        }
        if (this.rangeArgs.size() > 3) {
            throw new SoySyntaxException("Invalid range specification in 'for' command text \"" + string2 + "\".");
        }
        this.rangeArgTexts = Lists.newArrayList();
        for (ExprRootNode<ExprNode> exprRootNode : this.rangeArgs) {
            this.rangeArgTexts.add(exprRootNode.toSourceString());
        }
    }

    private SoySyntaxException createExceptionForInvalidCommandText(String string, Throwable throwable) {
        return new SoySyntaxException("Invalid " + string + " in 'for' command text \"" + this.getCommandText() + "\".", throwable);
    }

    @Override
    public String getLocalVarName() {
        return this.localVarName;
    }

    public List<String> getRangeArgTexts() {
        return this.rangeArgTexts;
    }

    public List<ExprRootNode<ExprNode>> getRangeArgs() {
        return this.rangeArgs;
    }

    @Override
    public List<? extends ExprRootNode<? extends ExprNode>> getAllExprs() {
        return this.rangeArgs;
    }
}

