/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentSoyCommandNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.SoyNode;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CallNode
extends AbstractParentSoyCommandNode<CallParamNode>
implements SoyNode.SplitLevelTopNode<CallParamNode>,
SoyNode.SoyStatementNode,
SoyNode.ParentExprHolderNode<CallParamNode>,
SoyNode.MsgPlaceholderNode {
    private static final Pattern NONATTRIBUTE_CALLEE_NAME = Pattern.compile("^ (?! name=\" | function=\") [.\\w]+ (?= \\s | $)", 4);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("call", new CommandTextAttributesParser.Attribute("name", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("function", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("data", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null));
    private String calleeName;
    private final boolean isPassingData;
    private final boolean isPassingAllData;
    private final String dataRefText;
    private final ExprRootNode<DataRefNode> dataRef;

    public CallNode(String string, String string2) throws SoySyntaxException {
        super(string, "call", string2);
        Matcher matcher = NONATTRIBUTE_CALLEE_NAME.matcher(string2);
        if (matcher.find()) {
            string2 = matcher.replaceFirst("name=\"" + matcher.group() + "\"");
        }
        Map<String, String> map = ATTRIBUTES_PARSER.parse(string2);
        String string3 = map.get("name");
        String string4 = map.get("function");
        if (string3 == null && string4 == null || string3 != null && string4 != null) {
            throw new SoySyntaxException("The 'call' command text must contain attribute 'name' (without attribute 'function').");
        }
        if (string3 != null) {
            this.calleeName = string3;
        } else {
            this.calleeName = string4;
            this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
        }
        if (!BaseUtils.isDottedIdentifier(this.calleeName)) {
            throw new SoySyntaxException("Invalid callee name \"" + this.calleeName + "\" for 'call' command.");
        }
        String string5 = map.get("data");
        if (string5 == null) {
            this.isPassingData = false;
            this.isPassingAllData = false;
            this.dataRefText = null;
            this.dataRef = null;
        } else if (string5.equals("all")) {
            this.isPassingData = true;
            this.isPassingAllData = true;
            this.dataRefText = null;
            this.dataRef = null;
        } else {
            this.isPassingData = true;
            this.isPassingAllData = false;
            this.dataRefText = string5;
            try {
                this.dataRef = new ExpressionParser(this.dataRefText).parseDataReference();
            }
            catch (TokenMgrError tokenMgrError) {
                throw this.createExceptionForInvalidDataRef(tokenMgrError);
            }
            catch (ParseException parseException) {
                throw this.createExceptionForInvalidDataRef(parseException);
            }
        }
    }

    private SoySyntaxException createExceptionForInvalidDataRef(Throwable throwable) {
        return new SoySyntaxException("Invalid data reference in 'call' command text \"" + this.getCommandText() + "\".", throwable);
    }

    public void setCalleeName(String string) {
        Preconditions.checkArgument((BaseUtils.isDottedIdentifier(string) && string.charAt(0) != '.' ? 1 : 0) != 0);
        this.calleeName = string;
    }

    public String getCalleeName() {
        return this.calleeName;
    }

    public boolean isPassingData() {
        return this.isPassingData;
    }

    public boolean isPassingAllData() {
        return this.isPassingAllData;
    }

    public String getDataRefText() {
        return this.dataRefText;
    }

    public ExprRootNode<DataRefNode> getDataRef() {
        return this.dataRef;
    }

    @Override
    public String getTagString() {
        return this.buildTagStringHelper(this.numChildren() == 0);
    }

    @Override
    public String toSourceString() {
        return this.numChildren() == 0 ? this.getTagString() : super.toSourceString();
    }

    @Override
    public List<? extends ExprRootNode<? extends ExprNode>> getAllExprs() {
        return this.dataRef != null ? ImmutableList.of(this.dataRef) : Collections.emptyList();
    }

    @Override
    public String genBasePlaceholderName() {
        return "XXX";
    }

    @Override
    public boolean isSamePlaceholderAs(SoyNode.MsgPlaceholderNode msgPlaceholderNode) {
        return false;
    }
}

