/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.CharMatcher;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.SoyNode;

public abstract class AbstractSoyCommandNode
extends AbstractSoyNode
implements SoyNode.SoyCommandNode {
    private final String commandName;
    private final String commandText;

    public AbstractSoyCommandNode(String string, String string2, String string3) {
        super(string);
        this.commandName = string2;
        this.commandText = string3.trim();
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public String getCommandText() {
        return this.commandText;
    }

    @Override
    public String getTagString() {
        return this.buildTagStringHelper(false);
    }

    protected String buildTagStringHelper(boolean bl) {
        String string;
        String string2 = string = bl ? " /" : "";
        if (this.commandText.length() == 0) {
            return "{" + this.commandName + string + "}";
        }
        if (CharMatcher.anyOf((CharSequence)"{}").matchesNoneOf((CharSequence)this.commandText)) {
            return "{" + this.commandName + " " + this.commandText + string + "}";
        }
        char c = this.commandText.charAt(this.commandText.length() - 1);
        if (c == '{' || c == '}') {
            if (bl) {
                return "{{" + this.commandName + " " + this.commandText + " /}}";
            }
            return "{{" + this.commandName + " " + this.commandText + " }}";
        }
        return "{{" + this.commandName + " " + this.commandText + string + "}}";
    }

    @Override
    public String toSourceString() {
        return this.getTagString();
    }
}

