/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.data.internalutils.DataUtils;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.GlobalNode;
import java.util.Map;
import javax.annotation.Nullable;

public class SubstituteGlobalsVisitor
extends AbstractExprNodeVisitor<Void> {
    private Map<String, PrimitiveData> compileTimeGlobals;
    private final boolean shouldAssertNoUnboundGlobals;

    public SubstituteGlobalsVisitor(@Nullable Map<String, PrimitiveData> map, boolean bl) {
        this.compileTimeGlobals = map;
        this.shouldAssertNoUnboundGlobals = bl;
    }

    @Override
    protected void visitInternal(GlobalNode globalNode) {
        PrimitiveData primitiveData;
        PrimitiveData primitiveData2 = primitiveData = this.compileTimeGlobals != null ? this.compileTimeGlobals.get(globalNode.getName()) : null;
        if (primitiveData == null) {
            if (this.shouldAssertNoUnboundGlobals) {
                throw new SoySyntaxException("Found unbound global '" + globalNode.getName() + "'.");
            }
            return;
        }
        ExprNode.ParentExprNode parentExprNode = globalNode.getParent();
        parentExprNode.setChild(parentExprNode.getChildIndex(globalNode), DataUtils.convertPrimitiveDataToExpr(primitiveData));
    }

    @Override
    protected void visitInternal(ExprNode exprNode) {
    }

    @Override
    protected void visitInternal(ExprNode.ParentExprNode parentExprNode) {
        this.visitChildren(parentExprNode);
    }
}

