/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RemoveHtmlCommentsVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final Pattern HTML_COMMENT = Pattern.compile("<!--.*?-->");
    private IdGenerator nodeIdGen;

    @Override
    protected void setup() {
        this.nodeIdGen = null;
    }

    @Override
    protected void visitInternal(RawTextNode rawTextNode) {
        Matcher matcher = HTML_COMMENT.matcher(rawTextNode.getRawText());
        if (!matcher.find()) {
            return;
        }
        matcher.reset();
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, "");
        }
        matcher.appendTail(stringBuffer);
        ParentNode parentNode = rawTextNode.getParent();
        if (stringBuffer.length() > 0) {
            if (this.nodeIdGen == null) {
                this.nodeIdGen = rawTextNode.getNearestAncestor(SoyFileSetNode.class).getNodeIdGen();
            }
            RawTextNode rawTextNode2 = new RawTextNode(this.nodeIdGen.genStringId(), stringBuffer.toString());
            parentNode.setChild(parentNode.getChildIndex(rawTextNode), rawTextNode2);
        } else {
            parentNode.removeChild(rawTextNode);
        }
    }

    @Override
    protected void visitInternal(SoyNode soyNode) {
    }

    @Override
    protected void visitInternal(SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode) {
        this.visitChildren(parentSoyNode);
    }
}

