/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.DataRefKeyNode;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachIfemptyNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.jssrc.GoogMsgNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class BuildNearestDependeeMapVisitor
extends AbstractSoyNodeVisitor<Map<SoyNode, SoyNode>> {
    private Deque<List<SoyNode>> potentialDependeeFrames;
    private Map<SoyNode, Set<SoyNode>> allDependeesMap;
    private Map<SoyNode, SoyNode> nearestDependeeMap;
    private static final Pattern TOP_LEVEL_REF = Pattern.compile("\\$([a-zA-Z0-9_]+)");

    @Override
    protected void setup() {
        this.potentialDependeeFrames = null;
        this.allDependeesMap = null;
        this.nearestDependeeMap = Maps.newHashMap();
    }

    @Override
    protected Map<SoyNode, SoyNode> getResult() {
        return this.nearestDependeeMap;
    }

    @Override
    protected void visitInternal(SoyFileSetNode soyFileSetNode) {
        this.visitChildren(soyFileSetNode);
    }

    @Override
    protected void visitInternal(SoyFileNode soyFileNode) {
        this.visitChildren(soyFileNode);
    }

    @Override
    protected void visitInternal(TemplateNode templateNode) {
        this.potentialDependeeFrames = new ArrayDeque<List<SoyNode>>();
        this.allDependeesMap = Maps.newHashMap();
        this.potentialDependeeFrames.push(Lists.newArrayList((Object[])new SoyNode[]{templateNode}));
        this.visitChildren(templateNode);
        this.potentialDependeeFrames.pop();
    }

    @Override
    protected void visitInternal(MsgNode msgNode) {
        this.visitParentPotentialDependeeHelper(msgNode, null);
    }

    @Override
    protected void visitInternal(GoogMsgNode googMsgNode) {
        this.visitParentPotentialDependeeHelper(googMsgNode, null);
        this.potentialDependeeFrames.peek().add(googMsgNode);
    }

    @Override
    protected void visitInternal(PrintNode printNode) {
        Set<String> set = BuildNearestDependeeMapVisitor.getTopLevelRefsInExpr(printNode.getExpr(), printNode.getExprText());
        this.visitParentPotentialDependeeHelper(printNode, set);
    }

    @Override
    protected void visitInternal(PrintDirectiveNode printDirectiveNode) {
        HashSet hashSet = Sets.newHashSet();
        for (ExprRootNode<ExprNode> exprRootNode : printDirectiveNode.getArgs()) {
            hashSet.addAll(BuildNearestDependeeMapVisitor.getTopLevelRefsInExpr(exprRootNode, null));
        }
        this.visitHelper(printDirectiveNode, hashSet);
    }

    @Override
    protected void visitInternal(IfNode ifNode) {
        this.visitParentPotentialDependeeHelper(ifNode, null);
    }

    @Override
    protected void visitInternal(IfCondNode ifCondNode) {
        Set<String> set = BuildNearestDependeeMapVisitor.getTopLevelRefsInExpr(ifCondNode.getExpr(), ifCondNode.getExprText());
        this.visitParentPotentialDependeeHelper(ifCondNode, set);
    }

    @Override
    protected void visitInternal(IfElseNode ifElseNode) {
        this.visitParentPotentialDependeeHelper(ifElseNode, null);
    }

    @Override
    protected void visitInternal(SwitchNode switchNode) {
        Set<String> set = BuildNearestDependeeMapVisitor.getTopLevelRefsInExpr(switchNode.getExpr(), switchNode.getExprText());
        this.visitParentPotentialDependeeHelper(switchNode, set);
    }

    @Override
    protected void visitInternal(SwitchCaseNode switchCaseNode) {
        HashSet hashSet = Sets.newHashSet();
        for (ExprRootNode<ExprNode> exprRootNode : switchCaseNode.getExprList()) {
            hashSet.addAll(BuildNearestDependeeMapVisitor.getTopLevelRefsInExpr(exprRootNode, null));
        }
        this.visitParentPotentialDependeeHelper(switchCaseNode, hashSet);
    }

    @Override
    protected void visitInternal(SwitchDefaultNode switchDefaultNode) {
        this.visitParentPotentialDependeeHelper(switchDefaultNode, null);
    }

    @Override
    protected void visitInternal(ForeachNode foreachNode) {
        Set<String> set = BuildNearestDependeeMapVisitor.getTopLevelRefsInExpr(foreachNode.getDataRef(), foreachNode.getDataRefText());
        this.visitParentPotentialDependeeHelper(foreachNode, set);
    }

    @Override
    protected void visitInternal(ForeachNonemptyNode foreachNonemptyNode) {
        this.visitParentPotentialDependeeHelper(foreachNonemptyNode, null);
    }

    @Override
    protected void visitInternal(ForeachIfemptyNode foreachIfemptyNode) {
        this.visitParentPotentialDependeeHelper(foreachIfemptyNode, null);
    }

    @Override
    protected void visitInternal(ForNode forNode) {
        HashSet hashSet = Sets.newHashSet();
        for (ExprRootNode<ExprNode> exprRootNode : forNode.getRangeArgs()) {
            hashSet.addAll(BuildNearestDependeeMapVisitor.getTopLevelRefsInExpr(exprRootNode, null));
        }
        this.visitParentPotentialDependeeHelper(forNode, hashSet);
    }

    @Override
    protected void visitInternal(CallNode callNode) {
        this.visitParentPotentialDependeeHelper(callNode, null);
    }

    @Override
    protected void visitInternal(SoyNode soyNode) {
        this.visitHelper(soyNode, null);
    }

    @Override
    protected void visitInternal(SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode) {
        this.potentialDependeeFrames.push(Lists.newArrayList());
        this.visitChildren(parentSoyNode);
        this.potentialDependeeFrames.pop();
        this.visitHelper(parentSoyNode, null);
    }

    private void visitHelper(SoyNode soyNode, @Nullable Set<String> set) {
        boolean bl = false;
        HashSet hashSet = Sets.newHashSetWithExpectedSize((int)4);
        for (List<SoyNode> list : this.potentialDependeeFrames) {
            for (int i = list.size() - 1; i >= 0; --i) {
                SoyNode soyNode2 = list.get(i);
                if (!this.isDependent(soyNode2, soyNode, set)) continue;
                if (!bl) {
                    this.nearestDependeeMap.put(soyNode, soyNode2);
                    bl = true;
                }
                hashSet.add(soyNode2);
            }
        }
        if (!bl) {
            throw new AssertionError();
        }
        this.allDependeesMap.put(soyNode, hashSet);
    }

    private boolean isDependent(SoyNode soyNode, SoyNode soyNode2, @Nullable Set<String> set) {
        if (soyNode instanceof TemplateNode || soyNode instanceof SoyNode.ConditionalBlockNode && !(soyNode instanceof SoyNode.LoopNode)) {
            return true;
        }
        if (soyNode2.getParent() == soyNode && (soyNode instanceof SoyNode.SplitLevelTopNode || soyNode instanceof MsgNode || soyNode instanceof GoogMsgNode)) {
            return true;
        }
        if (soyNode instanceof SoyNode.LocalVarNode) {
            if (set != null && set.contains(((SoyNode.LocalVarNode)soyNode).getLocalVarName())) {
                return true;
            }
            if (soyNode2 instanceof SoyNode.ParentSoyNode) {
                SoyNode.ParentSoyNode parentSoyNode = (SoyNode.ParentSoyNode)soyNode2;
                for (SoyNode soyNode3 : parentSoyNode.getChildren()) {
                    Set<SoyNode> set2 = this.allDependeesMap.get(soyNode3);
                    if (set2 == null) {
                        throw new AssertionError((Object)"Child has not been visited.");
                    }
                    if (!set2.contains(soyNode)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void visitParentPotentialDependeeHelper(SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode, @Nullable Set<String> set) {
        this.potentialDependeeFrames.push(Lists.newArrayList((Object[])new SoyNode[]{parentSoyNode}));
        this.visitChildren(parentSoyNode);
        this.potentialDependeeFrames.pop();
        this.visitHelper(parentSoyNode, set);
    }

    private static Set<String> getTopLevelRefsInExpr(@Nullable ExprNode exprNode, @Nullable String string) {
        if (exprNode != null) {
            return (Set)new GetTopLevelRefsInExprVisitor().exec(exprNode);
        }
        return BuildNearestDependeeMapVisitor.getTopLevelRefsInV1Expr(string);
    }

    private static Set<String> getTopLevelRefsInV1Expr(String string) {
        HashSet hashSet = Sets.newHashSet();
        Matcher matcher = TOP_LEVEL_REF.matcher(string);
        while (matcher.find()) {
            hashSet.add(matcher.group(1));
        }
        return hashSet;
    }

    private static class GetTopLevelRefsInExprVisitor
    extends AbstractExprNodeVisitor<Set<String>> {
        private Set<String> topLevelRefs;

        private GetTopLevelRefsInExprVisitor() {
        }

        @Override
        protected void setup() {
            this.topLevelRefs = Sets.newHashSet();
        }

        @Override
        protected Set<String> getResult() {
            return this.topLevelRefs;
        }

        @Override
        protected void visitInternal(DataRefNode dataRefNode) {
            this.topLevelRefs.add(((DataRefKeyNode)dataRefNode.getChild(0)).getKey());
            this.visitChildren(dataRefNode);
        }

        @Override
        protected void visitInternal(ExprNode exprNode) {
        }

        @Override
        protected void visitInternal(ExprNode.ParentExprNode parentExprNode) {
            this.visitChildren(parentExprNode);
        }
    }
}

