/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.data.internalutils.DataUtils;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.internal.base.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SoyGeneralOptions
implements Cloneable {
    private static final Pattern COMPILE_TIME_GLOBAL_LINE = Pattern.compile("([a-zA-Z_][a-zA-Z_0-9.]*) \\s* = \\s* (.+)", 4);
    private CssHandlingScheme cssHandlingScheme = CssHandlingScheme.LITERAL;
    private ImmutableMap<String, PrimitiveData> compileTimeGlobals = null;

    public void setCssHandlingScheme(CssHandlingScheme cssHandlingScheme) {
        this.cssHandlingScheme = cssHandlingScheme;
    }

    public CssHandlingScheme getCssHandlingScheme() {
        return this.cssHandlingScheme;
    }

    public void setCompileTimeGlobals(Map<String, ?> map) {
        Preconditions.checkState((this.compileTimeGlobals == null ? 1 : 0) != 0, (Object)"Compile-time globals already set.");
        this.compileTimeGlobals = DataUtils.convertCompileTimeGlobalsMap(map);
    }

    public void setCompileTimeGlobals(File file) throws IOException {
        this.setCompileTimeGlobalsHelper(Files.toString((File)file, (Charset)Charsets.UTF_8));
    }

    public void setCompileTimeGlobals(URL uRL) throws IOException {
        this.setCompileTimeGlobalsHelper(Resources.toString((URL)uRL, (Charset)Charsets.UTF_8));
    }

    private void setCompileTimeGlobalsHelper(String string) {
        CharSequence charSequence;
        Preconditions.checkState((this.compileTimeGlobals == null ? 1 : 0) != 0, (Object)"Compile-time globals already set.");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)0);
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        try {
            charSequence = bufferedReader.readLine();
            while (charSequence != null) {
                block14: {
                    if (!((String)charSequence).startsWith("//") && ((String)charSequence).trim().length() != 0) {
                        Matcher matcher = COMPILE_TIME_GLOBAL_LINE.matcher(charSequence);
                        if (!matcher.matches()) {
                            arrayList.add(Pair.of(CompileTimeGlobalsFileError.INVALID_FORMAT, charSequence));
                        } else {
                            PrimitiveData primitiveData;
                            Object object = matcher.group(1);
                            String string2 = matcher.group(2).trim();
                            try {
                                Node node = new ExpressionParser(string2).parseExpression().getChild(0);
                                if (!(node instanceof ExprNode.PrimitiveNode)) {
                                    if (node instanceof GlobalNode || node instanceof DataRefNode) {
                                        arrayList.add(Pair.of(CompileTimeGlobalsFileError.INVALID_VALUE, charSequence));
                                    } else {
                                        arrayList.add(Pair.of(CompileTimeGlobalsFileError.NON_PRIMITIVE_VALUE, charSequence));
                                    }
                                    break block14;
                                }
                                primitiveData = DataUtils.convertPrimitiveExprToData((ExprNode.PrimitiveNode)node);
                            }
                            catch (TokenMgrError tokenMgrError) {
                                arrayList.add(Pair.of(CompileTimeGlobalsFileError.INVALID_VALUE, charSequence));
                                break block14;
                            }
                            catch (ParseException parseException) {
                                arrayList.add(Pair.of(CompileTimeGlobalsFileError.INVALID_VALUE, charSequence));
                                break block14;
                            }
                            builder.put(object, (Object)primitiveData);
                        }
                    }
                }
                charSequence = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)"Should not have error reading a string.");
        }
        this.compileTimeGlobals = builder.build();
        if (arrayList.size() > 0) {
            charSequence = new StringBuilder("Compile-time globals file contains the following errors:\n");
            for (Object object : arrayList) {
                ((StringBuilder)charSequence).append("[").append(String.format("%-19s", ((CompileTimeGlobalsFileError)((Object)((Pair)object).first)).toString())).append("] ").append((String)((Pair)object).second).append("\n");
            }
            throw new SoySyntaxException(((StringBuilder)charSequence).toString());
        }
    }

    public ImmutableMap<String, PrimitiveData> getCompileTimeGlobals() {
        return this.compileTimeGlobals;
    }

    public SoyGeneralOptions clone() {
        try {
            return (SoyGeneralOptions)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Cloneable interface removed from SoyGeneralOptions");
        }
    }

    private static enum CompileTimeGlobalsFileError {
        INVALID_FORMAT("Invalid line format"),
        INVALID_VALUE("Invalid value"),
        NON_PRIMITIVE_VALUE("Non-primitive value");

        private final String errorString;

        private CompileTimeGlobalsFileError(String string2) {
            this.errorString = string2;
        }

        public String toString() {
            return this.errorString;
        }
    }

    public static enum CssHandlingScheme {
        LITERAL,
        REFERENCE,
        BACKEND_SPECIFIC;

    }
}

