/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parseinfo.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.IndentedLinesBuilder;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.sharedpasses.FindIndirectParamsVisitor;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GenerateParseInfoVisitor
extends AbstractSoyNodeVisitor<ImmutableMap<String, String>> {
    private final String javaPackage;
    private final JavaClassNameSource javaClassNameSource;
    private Map<SoyFileNode, String> soyFileToJavaClassNameMap;
    private Map<String, TemplateNode> templateNameToNodeMap;
    private final Map<String, String> convertedIdents = Maps.newHashMap();
    private LinkedHashMap<String, String> generatedFiles;
    private IndentedLinesBuilder ilb;

    public GenerateParseInfoVisitor(String string, String string2) {
        this.javaPackage = string;
        if (string2.equals("filename")) {
            this.javaClassNameSource = JavaClassNameSource.SOY_FILE_NAME;
        } else if (string2.equals("namespace")) {
            this.javaClassNameSource = JavaClassNameSource.SOY_NAMESPACE_LAST_PART;
        } else if (string2.equals("generic")) {
            this.javaClassNameSource = JavaClassNameSource.GENERIC;
        } else {
            throw new IllegalArgumentException("Invalid value for javaClassNameSource \"" + string2 + "\"" + " (valid values are \"filename\", \"namespace\", and \"generic\").");
        }
    }

    @Override
    protected void setup() {
        this.generatedFiles = Maps.newLinkedHashMap();
        this.ilb = null;
    }

    @Override
    protected ImmutableMap<String, String> getResult() {
        return ImmutableMap.copyOf(this.generatedFiles);
    }

    @Override
    protected void visitInternal(SoyFileSetNode soyFileSetNode) {
        HashMultimap hashMultimap = HashMultimap.create();
        for (Object object : soyFileSetNode.getChildren()) {
            hashMultimap.put((Object)this.javaClassNameSource.generateBaseClassName((SoyFileNode)object), object);
        }
        this.soyFileToJavaClassNameMap = Maps.newHashMap();
        for (Object object : hashMultimap.keySet()) {
            Object object2;
            Collection collection = hashMultimap.get(object);
            if (collection.size() == 1) {
                Object object3 = collection.iterator();
                while (object3.hasNext()) {
                    object2 = (SoyFileNode)object3.next();
                    this.soyFileToJavaClassNameMap.put((SoyFileNode)object2, (String)object + "SoyInfo");
                }
                continue;
            }
            int n = 1;
            object2 = collection.iterator();
            while (object2.hasNext()) {
                SoyFileNode soyFileNode = (SoyFileNode)object2.next();
                this.soyFileToJavaClassNameMap.put(soyFileNode, (String)object + n + "SoyInfo");
                ++n;
            }
        }
        this.templateNameToNodeMap = Maps.newHashMap();
        for (Object object : soyFileSetNode.getChildren()) {
            for (Object object3 : ((AbstractParentSoyNode)object).getChildren()) {
                this.templateNameToNodeMap.put(((TemplateNode)object3).getTemplateName(), (TemplateNode)object3);
            }
        }
        for (Object object : soyFileSetNode.getChildren()) {
            try {
                this.visit(object);
            }
            catch (SoySyntaxException soySyntaxException) {
                throw soySyntaxException.setFilePath(((SoyFileNode)object).getFilePath());
            }
        }
    }

    @Override
    protected void visitInternal(SoyFileNode soyFileNode) {
        if (soyFileNode.getFilePath() == null) {
            throw new SoySyntaxException("In order to generate parse info, all Soy files must have paths (file name is extracted from the path).");
        }
        String string = this.soyFileToJavaClassNameMap.get(soyFileNode);
        ArrayList arrayList = Lists.newArrayList();
        HashSet hashSet = Sets.newHashSet();
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
        for (Object object2 : soyFileNode.getChildren()) {
            if (!((TemplateNode)object2).isPrivate()) {
                arrayList.add(((TemplateNode)object2).getPartialTemplateName());
            }
            for (TemplateNode.SoyDocParam soyDocParam : ((TemplateNode)object2).getSoyDocParams()) {
                hashSet.add(soyDocParam.key);
                linkedHashMultimap.put((Object)soyDocParam.key, object2);
            }
        }
        TreeMap treeMap = Maps.newTreeMap();
        for (String string2 : hashSet) {
            String string3 = this.convertToUpperUnderscore(string2);
            if (treeMap.containsKey(string3)) {
                throw new SoySyntaxException("Cannot generate parse info because two param keys '" + (String)treeMap.get(string3) + "' and '" + string2 + "' generate the same upper-underscore name '" + string3 + "'.");
            }
            treeMap.put(string3, string2);
        }
        this.ilb = new IndentedLinesBuilder(2);
        this.ilb.appendLine("// This file was automatically generated from ", soyFileNode.getFileName(), ".");
        this.ilb.appendLine("// Please don't edit this file by hand.");
        this.ilb.appendLine(new String[0]);
        this.ilb.appendLine("package ", this.javaPackage, ";");
        this.ilb.appendLine(new String[0]);
        this.ilb.appendLine("import com.google.common.collect.ImmutableList;");
        this.ilb.appendLine("import com.google.common.collect.ImmutableMap;");
        this.ilb.appendLine("import com.google.common.collect.ImmutableSortedSet;");
        this.ilb.appendLine("import com.google.template.soy.parseinfo.SoyFileInfo;");
        this.ilb.appendLine("import com.google.template.soy.parseinfo.SoyTemplateInfo;");
        this.ilb.appendLine("import com.google.template.soy.parseinfo.SoyTemplateInfo.ParamRequisiteness;");
        this.ilb.appendLine("import static ", "com.google.template.soy.parseinfo.SoyTemplateInfo.ParamRequisiteness.OPTIONAL;");
        this.ilb.appendLine("import static ", "com.google.template.soy.parseinfo.SoyTemplateInfo.ParamRequisiteness.REQUIRED;");
        this.ilb.appendLine(new String[0]);
        this.ilb.appendLine(new String[0]);
        GenerateParseInfoVisitor.appendJavadoc(this.ilb, "Soy parse info for " + soyFileNode.getFileName() + ".", true, false);
        this.ilb.appendLine("public class ", string, " extends SoyFileInfo {");
        this.ilb.increaseIndent();
        this.ilb.appendLine(new String[0]);
        this.ilb.appendLine(new String[0]);
        this.ilb.appendLine("public static class Param {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("private Param() {}");
        this.ilb.appendLine(new String[0]);
        for (Map.Entry entry : treeMap.entrySet()) {
            String string4 = (String)entry.getKey();
            String string5 = (String)entry.getValue();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Listed by ");
            boolean bl = true;
            for (TemplateNode templateNode : linkedHashMultimap.get((Object)string5)) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(templateNode.getPartialTemplateName());
                if (!templateNode.isPrivate()) continue;
                stringBuilder.append(" (private)");
            }
            stringBuilder.append(".");
            GenerateParseInfoVisitor.appendJavadoc(this.ilb, stringBuilder.toString(), false, true);
            this.ilb.appendLine("public static final String ", string4, " = \"", string5, "\";");
        }
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        for (TemplateNode templateNode : soyFileNode.getChildren()) {
            try {
                this.visit(templateNode);
            }
            catch (SoySyntaxException soySyntaxException) {
                throw soySyntaxException.setTemplateName(templateNode.getTemplateName());
            }
        }
        this.ilb.appendLine(new String[0]);
        this.ilb.appendLine(new String[0]);
        this.ilb.appendLine("private ", string, "() {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("super(\"", soyFileNode.getFileName(), "\",");
        this.ilb.setIndentLen(this.ilb.getCurrIndentLen() + 6);
        this.ilb.appendLine("\"", soyFileNode.getNamespace(), "\",");
        this.ilb.appendLine("ImmutableSortedSet.<String>of(");
        this.ilb.increaseIndent();
        this.ilb.increaseIndent();
        boolean bl = true;
        for (String string6 : treeMap.keySet()) {
            if (bl) {
                bl = false;
            } else {
                this.ilb.append(",\n");
            }
            this.ilb.appendIndent().append("Param.").append(string6);
        }
        this.ilb.append("),").appendLineEnd();
        this.ilb.decreaseIndent();
        this.ilb.decreaseIndent();
        this.ilb.appendLine("ImmutableList.<SoyTemplateInfo>of(");
        this.ilb.increaseIndent();
        this.ilb.increaseIndent();
        bl = true;
        for (String string7 : arrayList) {
            if (bl) {
                bl = false;
            } else {
                this.ilb.append(",\n");
            }
            this.ilb.appendIndent().append(this.convertToUpperUnderscore(string7.substring(1)));
        }
        this.ilb.append("));").appendLineEnd();
        this.ilb.decreaseIndent();
        this.ilb.decreaseIndent();
        this.ilb.setIndentLen(this.ilb.getCurrIndentLen() - 6);
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new String[0]);
        this.ilb.appendLine("private static final ", string, " __INSTANCE__ = new ", string, "();");
        this.ilb.appendLine(new String[0]);
        this.ilb.appendLine("public static ", string, " getInstance() {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("return __INSTANCE__;");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new String[0]);
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.generatedFiles.put(string + ".java", this.ilb.toString());
        this.ilb = null;
    }

    @Override
    protected void visitInternal(TemplateNode templateNode) {
        if (templateNode.isPrivate()) {
            return;
        }
        FindIndirectParamsVisitor.IndirectParamsInfo indirectParamsInfo = (FindIndirectParamsVisitor.IndirectParamsInfo)new FindIndirectParamsVisitor(false, true, this.templateNameToNodeMap).exec(templateNode);
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        for (TemplateNode.SoyDocParam object : templateNode.getSoyDocParams()) {
            linkedHashMap.put(object.key, object);
        }
        for (TemplateNode.SoyDocParam soyDocParam : indirectParamsInfo.indirectParams.values()) {
            TemplateNode.SoyDocParam soyDocParam2 = (TemplateNode.SoyDocParam)linkedHashMap.get(soyDocParam.key);
            if (soyDocParam2 != null) continue;
            linkedHashMap.put(soyDocParam.key, new TemplateNode.SoyDocParam(soyDocParam.key, soyDocParam.isRequired, null));
        }
        String string = this.convertToUpperUnderscore(templateNode.getPartialTemplateName().substring(1));
        if (linkedHashMap.size() == 0) {
            this.ilb.appendLine(new String[0]);
            this.ilb.appendLine(new String[0]);
            GenerateParseInfoVisitor.appendJavadoc(this.ilb, templateNode.getSoyDocDesc(), true, false);
            this.ilb.appendLine("public static final SoyTemplateInfo ", string, " = new SoyTemplateInfo(");
            this.ilb.increaseIndent();
            this.ilb.increaseIndent();
            this.ilb.appendLine("\"", templateNode.getTemplateName(), "\",");
            this.ilb.appendLine("ImmutableMap.<String, ParamRequisiteness>of());");
            this.ilb.decreaseIndent();
            this.ilb.decreaseIndent();
        } else {
            String string2 = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, string) + "SoyTemplateInfo";
            this.ilb.appendLine(new String[0]);
            this.ilb.appendLine(new String[0]);
            GenerateParseInfoVisitor.appendJavadoc(this.ilb, templateNode.getSoyDocDesc(), true, false);
            this.ilb.appendLine("public static final ", string2, " ", string, " =");
            this.ilb.appendLine("    new ", string2, "();");
            this.ilb.appendLine(new String[0]);
            this.ilb.appendLine("public static class ", string2, " extends SoyTemplateInfo {");
            this.ilb.increaseIndent();
            this.ilb.appendLine("private ", string2, "() {");
            this.ilb.increaseIndent();
            this.ilb.appendLine("super(\"", templateNode.getTemplateName(), "\",");
            this.ilb.appendLine("      ImmutableMap.<String, ParamRequisiteness>builder()");
            for (Object object : linkedHashMap.values()) {
                this.ilb.appendLine("      .put(\"", ((TemplateNode.SoyDocParam)object).key, "\", ", ((TemplateNode.SoyDocParam)object).isRequired ? "REQUIRED" : "OPTIONAL", ")");
            }
            this.ilb.appendLine("      .build());");
            this.ilb.decreaseIndent();
            this.ilb.appendLine("}");
            boolean bl = false;
            for (TemplateNode.SoyDocParam soyDocParam : linkedHashMap.values()) {
                if (soyDocParam.desc != null) {
                    this.ilb.appendLine(new String[0]);
                    GenerateParseInfoVisitor.appendJavadoc(this.ilb, soyDocParam.desc, false, false);
                } else {
                    if (!bl) {
                        this.ilb.appendLine(new String[0]);
                        this.ilb.appendLine("// Indirect params.");
                        bl = true;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Listed by ");
                    boolean bl2 = true;
                    for (TemplateNode templateNode2 : indirectParamsInfo.paramKeyToCalleesMultimap.get((Object)soyDocParam.key)) {
                        if (bl2) {
                            bl2 = false;
                        } else {
                            stringBuilder.append(", ");
                        }
                        if (templateNode2.getParent() == templateNode.getParent()) {
                            stringBuilder.append(templateNode2.getPartialTemplateName());
                        } else {
                            stringBuilder.append(templateNode2.getTemplateName());
                        }
                        if (!templateNode2.isPrivate()) continue;
                        stringBuilder.append(" (private)");
                    }
                    stringBuilder.append(".");
                    GenerateParseInfoVisitor.appendJavadoc(this.ilb, stringBuilder.toString(), false, true);
                }
                this.ilb.appendLine("public final String ", this.convertToUpperUnderscore(soyDocParam.key), " = \"", soyDocParam.key, "\";");
            }
            this.ilb.decreaseIndent();
            this.ilb.appendLine("}");
        }
    }

    private String convertToUpperUnderscore(String string) {
        String string2 = this.convertedIdents.get(string);
        if (string2 == null) {
            string2 = BaseUtils.convertToUpperUnderscore(string);
            this.convertedIdents.put(string, string2);
        }
        return string2;
    }

    private static void appendJavadoc(IndentedLinesBuilder indentedLinesBuilder, String string, boolean bl, boolean bl2) {
        if (bl2) {
            int n = 100 - indentedLinesBuilder.getCurrIndentLen() - 7;
            Object object = Lists.newArrayList();
            for (String string2 : Splitter.on((char)'\n').split((CharSequence)string)) {
                while (string2.length() > n) {
                    int n2 = string2.lastIndexOf(32, n);
                    object.add(string2.substring(0, n2));
                    string2 = string2.substring(n2 + 1);
                }
                object.add(string2);
            }
            string = Joiner.on((String)"\n").join((Iterable)object);
        }
        if (string.contains("\n") || bl) {
            indentedLinesBuilder.appendLine("/**");
            for (Object object : Splitter.on((char)'\n').split((CharSequence)string)) {
                indentedLinesBuilder.appendLine(new String[]{" * ", object});
            }
            indentedLinesBuilder.appendLine(" */");
        } else {
            indentedLinesBuilder.appendLine("/** ", string, " */");
        }
    }

    @VisibleForTesting
    static enum JavaClassNameSource {
        SOY_FILE_NAME,
        SOY_NAMESPACE_LAST_PART,
        GENERIC;

        private static final Pattern ALL_UPPER_WORD;
        private static final Pattern ALL_LOWER_WORD;
        private static final Pattern NON_LETTER_DIGIT;

        @VisibleForTesting
        String generateBaseClassName(SoyFileNode soyFileNode) {
            switch (this) {
                case SOY_FILE_NAME: {
                    String string = soyFileNode.getFileName();
                    if (string == null) {
                        throw new IllegalArgumentException("Trying to generate Java class name based on Soy file name, but Soy file name was not provided.");
                    }
                    if (string.toLowerCase().endsWith(".soy")) {
                        string = string.substring(0, string.length() - 4);
                    }
                    return JavaClassNameSource.makeUpperCamelCase(string);
                }
                case SOY_NAMESPACE_LAST_PART: {
                    String string = soyFileNode.getNamespace();
                    String string2 = string.substring(string.lastIndexOf(46) + 1);
                    return JavaClassNameSource.makeUpperCamelCase(string2);
                }
                case GENERIC: {
                    return "File";
                }
            }
            throw new AssertionError();
        }

        private static String makeUpperCamelCase(String string) {
            string = JavaClassNameSource.makeWordsCapitalized(string, ALL_UPPER_WORD);
            string = JavaClassNameSource.makeWordsCapitalized(string, ALL_LOWER_WORD);
            string = NON_LETTER_DIGIT.matcher(string).replaceAll("");
            return string;
        }

        private static String makeWordsCapitalized(String string, Pattern pattern) {
            StringBuffer stringBuffer = new StringBuffer();
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                String string2 = matcher.group();
                StringBuilder stringBuilder = new StringBuilder();
                int n = string2.length();
                for (int i = 0; i < n; ++i) {
                    if (i == 0) {
                        stringBuilder.append(Character.toUpperCase(string2.charAt(i)));
                        continue;
                    }
                    stringBuilder.append(Character.toLowerCase(string2.charAt(i)));
                }
                matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(stringBuilder.toString()));
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }

        static {
            ALL_UPPER_WORD = Pattern.compile("(?<= [^A-Za-z] | ^)  [A-Z]+  (?= [^A-Za-z] | $)", 4);
            ALL_LOWER_WORD = Pattern.compile("(?<= [^A-Za-z] | ^)  [a-z]+  (?= [^a-z] | $)", 4);
            NON_LETTER_DIGIT = Pattern.compile("[^A-Za-z0-9]");
        }
    }
}

