/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.internal;

import com.google.common.collect.Lists;
import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.sharedpasses.CombineConsecutiveRawTextNodesVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import javax.annotation.Nullable;

public class InsertMsgsVisitor
extends AbstractSoyNodeVisitor<Void> {
    private final SoyMsgBundle msgBundle;
    private IdGenerator nodeIdGen;
    private List<SoyNode> currNewChildren;

    public InsertMsgsVisitor(@Nullable SoyMsgBundle soyMsgBundle) {
        this.msgBundle = soyMsgBundle;
    }

    @Override
    public Void exec(SoyNode soyNode) {
        this.nodeIdGen = soyNode.getNearestAncestor(SoyFileSetNode.class).getNodeIdGen();
        super.exec(soyNode);
        new CombineConsecutiveRawTextNodesVisitor().exec(soyNode);
        return null;
    }

    @Override
    protected void visitInternal(MsgNode msgNode) {
        SoyMsg soyMsg;
        long l = MsgUtils.computeMsgId(msgNode);
        SoyMsg soyMsg2 = soyMsg = this.msgBundle == null ? null : this.msgBundle.getMsg(l);
        if (soyMsg != null) {
            for (SoyMsgPart soyMsgPart : soyMsg.getParts()) {
                String string;
                if (soyMsgPart instanceof SoyMsgRawTextPart) {
                    string = ((SoyMsgRawTextPart)soyMsgPart).getRawText();
                    this.currNewChildren.add(new RawTextNode(this.nodeIdGen.genStringId(), string));
                    continue;
                }
                if (soyMsgPart instanceof SoyMsgPlaceholderPart) {
                    string = ((SoyMsgPlaceholderPart)soyMsgPart).getPlaceholderName();
                    SoyNode.MsgPlaceholderNode msgPlaceholderNode = msgNode.getPlaceholderNode(string);
                    if (msgPlaceholderNode instanceof MsgHtmlTagNode) {
                        this.visit(msgPlaceholderNode);
                        continue;
                    }
                    this.currNewChildren.add(msgPlaceholderNode);
                    continue;
                }
                throw new AssertionError();
            }
        } else {
            for (SoyNode soyNode : msgNode.getChildren()) {
                if (soyNode instanceof MsgHtmlTagNode) {
                    this.visit((MsgHtmlTagNode)soyNode);
                    continue;
                }
                this.currNewChildren.add(soyNode);
            }
        }
    }

    @Override
    protected void visitInternal(MsgHtmlTagNode msgHtmlTagNode) {
        for (SoyNode soyNode : msgHtmlTagNode.getChildren()) {
            this.currNewChildren.add(soyNode);
        }
    }

    @Override
    protected void visitInternal(SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode) {
        boolean bl = false;
        for (Object object : parentSoyNode.getChildren()) {
            if (object instanceof MsgNode) {
                bl = true;
                continue;
            }
            if (!(object instanceof SoyNode.ParentSoyNode)) continue;
            this.visit(object);
        }
        if (!bl) {
            return;
        }
        SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode2 = parentSoyNode;
        this.currNewChildren = Lists.newArrayList();
        for (SoyNode soyNode : parentSoyNode2.getChildren()) {
            if (soyNode instanceof MsgNode) {
                this.visit((MsgNode)soyNode);
                continue;
            }
            this.currNewChildren.add(soyNode);
        }
        parentSoyNode2.clearChildren();
        parentSoyNode2.addChildren(this.currNewChildren);
    }
}

