/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.internal;

import com.google.common.collect.Lists;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgBundleImpl;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;

public class ExtractMsgsVisitor
extends AbstractSoyNodeVisitor<SoyMsgBundle> {
    List<SoyMsg> msgs;
    String currentSource;

    @Override
    protected void setup() {
        this.msgs = Lists.newArrayList();
        this.currentSource = null;
    }

    @Override
    protected SoyMsgBundle getResult() {
        return new SoyMsgBundleImpl(null, this.msgs);
    }

    @Override
    protected void visitInternal(SoyFileNode soyFileNode) {
        this.currentSource = soyFileNode.getFilePath();
        this.visitChildren(soyFileNode);
        this.currentSource = null;
    }

    @Override
    protected void visitInternal(MsgNode msgNode) {
        Pair<List<SoyMsgPart>, Long> pair = MsgUtils.buildMsgPartsAndComputeMsgId(msgNode);
        this.msgs.add(new SoyMsg((Long)pair.second, null, msgNode.getMeaning(), msgNode.getDesc(), msgNode.isHidden(), msgNode.getContentType(), this.currentSource, (List)pair.first));
    }

    @Override
    protected void visitInternal(SoyNode soyNode) {
    }

    @Override
    protected void visitInternal(SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode) {
        this.visitChildren(parentSoyNode);
    }
}

