/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.DataRefIndexNode;
import com.google.template.soy.exprtree.DataRefKeyNode;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsCodeUtils;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.shared.internal.ImpureFunction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Map;

public class TranslateToJsExprVisitor
extends AbstractExprNodeVisitor<JsExpr> {
    private final Map<String, SoyJsSrcFunction> soyJsSrcFunctionsMap;
    private final Deque<Map<String, JsExpr>> localVarTranslations;
    private Deque<JsExpr> resultStack;
    private static final ImmutableSet<String> JS_RESERVED_WORDS = ImmutableSet.of((Object)"break", (Object)"case", (Object)"catch", (Object)"class", (Object)"const", (Object)"continue", (Object[])new String[]{"debugger", "default", "delete", "do", "else", "enum", "export", "extends", "finally", "for", "function", "if", "implements", "import", "in", "instanceof", "interface", "let", "new", "package", "private", "protected", "public", "return", "static", "super", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "yield"});

    @AssistedInject
    TranslateToJsExprVisitor(Map<String, SoyJsSrcFunction> map, @Assisted Deque<Map<String, JsExpr>> deque) {
        this.soyJsSrcFunctionsMap = map;
        this.localVarTranslations = deque;
    }

    @Override
    protected void setup() {
        this.resultStack = new ArrayDeque<JsExpr>();
    }

    @Override
    protected JsExpr getResult() {
        return this.resultStack.peek();
    }

    @Override
    protected void visitInternal(ExprRootNode<? extends ExprNode> exprRootNode) {
        this.visitChildren(exprRootNode);
    }

    @Override
    protected void visitInternal(StringNode stringNode) {
        this.resultStack.push(new JsExpr(JsSrcUtils.escapeUnicodeFormatChars(stringNode.toSourceString()), Integer.MAX_VALUE));
    }

    @Override
    protected void visitInternal(DataRefNode dataRefNode) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = ((DataRefKeyNode)dataRefNode.getChild(0)).getKey();
        JsExpr jsExpr = this.getLocalVarTranslation(string);
        if (jsExpr != null) {
            stringBuilder.append(jsExpr.getText());
        } else {
            stringBuilder.append("opt_data");
            this.appendDataRefKey(stringBuilder, string);
        }
        int n = dataRefNode.numChildren();
        if (n > 1) {
            for (int i = 1; i < n; ++i) {
                ExprNode exprNode = dataRefNode.getChild(i);
                if (exprNode instanceof DataRefKeyNode) {
                    this.appendDataRefKey(stringBuilder, ((DataRefKeyNode)exprNode).getKey());
                    continue;
                }
                if (exprNode instanceof DataRefIndexNode) {
                    stringBuilder.append("[").append(((DataRefIndexNode)exprNode).getIndex()).append("]");
                    continue;
                }
                this.visit(exprNode);
                stringBuilder.append("[").append(this.resultStack.pop().getText()).append("]");
            }
        }
        this.resultStack.push(new JsExpr(stringBuilder.toString(), Integer.MAX_VALUE));
    }

    @Override
    protected void visitInternal(GlobalNode globalNode) {
        this.resultStack.push(new JsExpr(globalNode.toSourceString(), Integer.MAX_VALUE));
    }

    @Override
    protected void visitInternal(OperatorNodes.NotOpNode notOpNode) {
        this.resultStack.push(this.genJsExprUsingSoySyntaxWithNewToken(notOpNode, "!"));
    }

    @Override
    protected void visitInternal(OperatorNodes.AndOpNode andOpNode) {
        this.resultStack.push(this.genJsExprUsingSoySyntaxWithNewToken(andOpNode, "&&"));
    }

    @Override
    protected void visitInternal(OperatorNodes.OrOpNode orOpNode) {
        this.resultStack.push(this.genJsExprUsingSoySyntaxWithNewToken(orOpNode, "||"));
    }

    @Override
    protected void visitInternal(FunctionNode functionNode) {
        String string = functionNode.getFunctionName();
        int n = functionNode.numChildren();
        ImpureFunction impureFunction = ImpureFunction.forFunctionName(string);
        if (impureFunction != null) {
            if (n != impureFunction.getNumArgs()) {
                throw new SoySyntaxException("Function '" + string + "' called with the wrong number of arguments" + " (function call \"" + functionNode.toSourceString() + "\").");
            }
            switch (impureFunction) {
                case IS_FIRST: {
                    this.visitIsFirstFunction(functionNode);
                    return;
                }
                case IS_LAST: {
                    this.visitIsLastFunction(functionNode);
                    return;
                }
                case INDEX: {
                    this.visitIndexFunction(functionNode);
                    return;
                }
                case HAS_DATA: {
                    this.visitHasDataFunction();
                    return;
                }
            }
            throw new AssertionError();
        }
        SoyJsSrcFunction soyJsSrcFunction = this.soyJsSrcFunctionsMap.get(string);
        if (soyJsSrcFunction != null) {
            if (!soyJsSrcFunction.getValidArgsSizes().contains(n)) {
                throw new SoySyntaxException("Function '" + string + "' called with the wrong number of arguments" + " (function call \"" + functionNode.toSourceString() + "\").");
            }
            ArrayList arrayList = Lists.newArrayList();
            for (ExprNode exprNode : functionNode.getChildren()) {
                this.visit(exprNode);
                arrayList.add(this.resultStack.pop());
            }
            try {
                this.resultStack.push(soyJsSrcFunction.computeForJsSrc(arrayList));
            }
            catch (Exception exception) {
                throw new SoySyntaxException("Error in function call \"" + functionNode.toSourceString() + "\": " + exception.getMessage(), exception);
            }
            return;
        }
        throw new SoySyntaxException("Failed to find SoyJsSrcFunction with name '" + string + "'" + " (function call \"" + functionNode.toSourceString() + "\").");
    }

    private void visitIsFirstFunction(FunctionNode functionNode) {
        String string = ((DataRefKeyNode)((DataRefNode)functionNode.getChild(0)).getChild(0)).getKey();
        this.resultStack.push(this.getLocalVarTranslation(string + "__isFirst"));
    }

    private void visitIsLastFunction(FunctionNode functionNode) {
        String string = ((DataRefKeyNode)((DataRefNode)functionNode.getChild(0)).getChild(0)).getKey();
        this.resultStack.push(this.getLocalVarTranslation(string + "__isLast"));
    }

    private void visitIndexFunction(FunctionNode functionNode) {
        String string = ((DataRefKeyNode)((DataRefNode)functionNode.getChild(0)).getChild(0)).getKey();
        this.resultStack.push(this.getLocalVarTranslation(string + "__index"));
    }

    private void visitHasDataFunction() {
        this.resultStack.push(new JsExpr("opt_data != null", Operator.NOT_EQUAL.getPrecedence()));
    }

    @Override
    protected void visitInternal(ExprNode.OperatorNode operatorNode) {
        this.resultStack.push(this.genJsExprUsingSoySyntax(operatorNode));
    }

    @Override
    protected void visitInternal(ExprNode.PrimitiveNode primitiveNode) {
        this.resultStack.push(new JsExpr(primitiveNode.toSourceString(), Integer.MAX_VALUE));
    }

    private JsExpr getLocalVarTranslation(String string) {
        for (Map<String, JsExpr> map : this.localVarTranslations) {
            JsExpr jsExpr = map.get(string);
            if (jsExpr == null) continue;
            return jsExpr;
        }
        return null;
    }

    private JsExpr genJsExprUsingSoySyntax(ExprNode.OperatorNode operatorNode) {
        return this.genJsExprUsingSoySyntaxWithNewToken(operatorNode, null);
    }

    private JsExpr genJsExprUsingSoySyntaxWithNewToken(ExprNode.OperatorNode operatorNode, String string) {
        ArrayList arrayList = Lists.newArrayList();
        for (ExprNode exprNode : operatorNode.getChildren()) {
            this.visit(exprNode);
            arrayList.add(this.resultStack.pop());
        }
        return SoyJsCodeUtils.genJsExprUsingSoySyntaxWithNewToken(operatorNode.getOperator(), arrayList, string);
    }

    private void appendDataRefKey(StringBuilder stringBuilder, String string) {
        if (JS_RESERVED_WORDS.contains((Object)string)) {
            stringBuilder.append("['").append(string).append("']");
        } else {
            stringBuilder.append(".").append(string);
        }
    }

    public static interface TranslateToJsExprVisitorFactory {
        public TranslateToJsExprVisitor create(Deque<Map<String, JsExpr>> var1);
    }
}

