/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.jssrc.GoogMsgNode;
import com.google.template.soy.soytree.jssrc.GoogMsgRefNode;
import java.util.List;

class ReplaceMsgsWithGoogMsgsVisitor
extends AbstractSoyNodeVisitor<Void> {
    private final SoyJsSrcOptions jsSrcOptions;
    private List<MsgNode> msgNodes;

    @Inject
    ReplaceMsgsWithGoogMsgsVisitor(SoyJsSrcOptions soyJsSrcOptions) {
        this.jsSrcOptions = soyJsSrcOptions;
    }

    @Override
    protected void setup() {
        this.msgNodes = Lists.newArrayList();
    }

    @Override
    protected void visitInternal(SoyFileSetNode soyFileSetNode) {
        this.visitChildren(soyFileSetNode);
        IdGenerator idGenerator = soyFileSetNode.getNearestAncestor(SoyFileSetNode.class).getNodeIdGen();
        for (MsgNode msgNode : this.msgNodes) {
            this.replaceMsgNodeHelper(msgNode, idGenerator);
        }
    }

    @Override
    protected void visitInternal(MsgNode msgNode) {
        this.msgNodes.add(msgNode);
        this.visitChildren(msgNode);
    }

    @Override
    protected void visitInternal(SoyNode soyNode) {
    }

    @Override
    protected void visitInternal(SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode) {
        this.visitChildren(parentSoyNode);
    }

    private void replaceMsgNodeHelper(MsgNode msgNode, IdGenerator idGenerator) {
        String string = idGenerator.genStringId();
        String string2 = this.jsSrcOptions.googMsgsAreExternal() ? "MSG_EXTERNAL_" + MsgUtils.computeMsgId(msgNode) : "MSG_UNNAMED_" + string;
        GoogMsgNode googMsgNode = new GoogMsgNode(string, msgNode, string2);
        GoogMsgRefNode googMsgRefNode = new GoogMsgRefNode(idGenerator.genStringId(), string2);
        ParentNode parentNode = msgNode.getParent();
        int n = parentNode.getChildIndex(msgNode);
        parentNode.setChild(n, googMsgNode);
        parentNode.addChild(n + 1, googMsgRefNode);
    }
}

