/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsExprTranslator;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.soytree.AbstractParentSoyCommandNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.jssrc.GoogMsgRefNode;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;

public class GenJsExprsVisitor
extends AbstractSoyNodeVisitor<List<JsExpr>> {
    Map<String, SoyJsSrcPrintDirective> soyJsSrcDirectivesMap;
    private final JsExprTranslator jsExprTranslator;
    private final GenCallCodeUtils genCallCodeUtils;
    private final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final GenJsExprsVisitorFactory genJsExprsVisitorFactory;
    private final Deque<Map<String, JsExpr>> localVarTranslations;
    private List<JsExpr> jsExprs;

    @AssistedInject
    GenJsExprsVisitor(Map<String, SoyJsSrcPrintDirective> map, JsExprTranslator jsExprTranslator, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, GenJsExprsVisitorFactory genJsExprsVisitorFactory, @Assisted Deque<Map<String, JsExpr>> deque) {
        this.soyJsSrcDirectivesMap = map;
        this.jsExprTranslator = jsExprTranslator;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.genJsExprsVisitorFactory = genJsExprsVisitorFactory;
        this.localVarTranslations = deque;
    }

    @Override
    public List<JsExpr> exec(SoyNode soyNode) {
        Preconditions.checkArgument((boolean)((Boolean)this.isComputableAsJsExprsVisitor.exec(soyNode)));
        return (List)super.exec(soyNode);
    }

    @Override
    protected void setup() {
        this.jsExprs = Lists.newArrayList();
    }

    @Override
    protected List<JsExpr> getResult() {
        return this.jsExprs;
    }

    @Override
    protected void visitInternal(TemplateNode templateNode) {
        this.visitChildren(templateNode);
    }

    @Override
    protected void visitInternal(RawTextNode rawTextNode) {
        String string = BaseUtils.escapeToSoyString(rawTextNode.getRawText(), false);
        string = JsSrcUtils.escapeUnicodeFormatChars(string);
        this.jsExprs.add(new JsExpr(string, Integer.MAX_VALUE));
    }

    @Override
    protected void visitInternal(GoogMsgRefNode googMsgRefNode) {
        this.jsExprs.add(new JsExpr(googMsgRefNode.getGoogMsgName(), Integer.MAX_VALUE));
    }

    @Override
    protected void visitInternal(MsgHtmlTagNode msgHtmlTagNode) {
        this.visitChildren(msgHtmlTagNode);
    }

    @Override
    protected void visitInternal(PrintNode printNode) {
        JsExpr jsExpr = this.jsExprTranslator.translateToJsExpr(printNode.getExpr(), printNode.getExprText(), this.localVarTranslations);
        for (PrintDirectiveNode printDirectiveNode : printNode.getChildren()) {
            SoyJsSrcPrintDirective soyJsSrcPrintDirective = this.soyJsSrcDirectivesMap.get(printDirectiveNode.getName());
            if (soyJsSrcPrintDirective == null) {
                throw new SoySyntaxException("Failed to find SoyJsSrcPrintDirective with name '" + printDirectiveNode.getName() + "'" + " (tag " + printNode.toSourceString() + ")");
            }
            List<ExprRootNode<ExprNode>> list = printDirectiveNode.getArgs();
            if (!soyJsSrcPrintDirective.getValidArgsSizes().contains(list.size())) {
                throw new SoySyntaxException("Print directive '" + printDirectiveNode.getName() + "' used with the wrong number of" + " arguments (tag " + printNode.toSourceString() + ").");
            }
            ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
            for (ExprRootNode<ExprNode> exprRootNode : list) {
                arrayList.add(this.jsExprTranslator.translateToJsExpr(exprRootNode, null, this.localVarTranslations));
            }
            jsExpr = soyJsSrcPrintDirective.applyForJsSrc(jsExpr, arrayList);
        }
        this.jsExprs.add(jsExpr);
    }

    @Override
    protected void visitInternal(CssNode cssNode) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("goog.getCssName(");
        String string = cssNode.getCommandText();
        int n = cssNode.getCommandText().lastIndexOf(44);
        if (n != -1) {
            String string2 = cssNode.getCommandText().substring(0, n).trim();
            ExprRootNode<ExprNode> exprRootNode = null;
            try {
                exprRootNode = new ExpressionParser(string2).parseExpression();
            }
            catch (TokenMgrError tokenMgrError) {
                throw this.createExceptionForInvalidBase(string2, tokenMgrError);
            }
            catch (ParseException parseException) {
                throw this.createExceptionForInvalidBase(string2, parseException);
            }
            JsExpr jsExpr = this.jsExprTranslator.translateToJsExpr(exprRootNode, string2, this.localVarTranslations);
            stringBuilder.append(jsExpr.getText()).append(", ");
            string = cssNode.getCommandText().substring(n + 1).trim();
        }
        stringBuilder.append("'").append(string).append("')");
        this.jsExprs.add(new JsExpr(stringBuilder.toString(), Integer.MAX_VALUE));
    }

    private SoySyntaxException createExceptionForInvalidBase(String string, Throwable throwable) {
        return new SoySyntaxException("Invalid expression for base in 'css' command text \"" + string + "\".", throwable);
    }

    @Override
    protected void visitInternal(IfNode ifNode) {
        GenJsExprsVisitor genJsExprsVisitor = this.genJsExprsVisitorFactory.create(this.localVarTranslations);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (SoyNode soyNode : ifNode.getChildren()) {
            Object object;
            AbstractParentSoyCommandNode abstractParentSoyCommandNode;
            if (soyNode instanceof IfCondNode) {
                abstractParentSoyCommandNode = (IfCondNode)soyNode;
                object = this.jsExprTranslator.translateToJsExpr(abstractParentSoyCommandNode.getExpr(), abstractParentSoyCommandNode.getExprText(), this.localVarTranslations);
                stringBuilder.append("(").append(((JsExpr)object).getText()).append(") ? ");
                List<JsExpr> list = genJsExprsVisitor.exec(abstractParentSoyCommandNode);
                stringBuilder.append(JsExprUtils.concatJsExprs(list).getText());
                stringBuilder.append(" : ");
                continue;
            }
            if (soyNode instanceof IfElseNode) {
                bl = true;
                abstractParentSoyCommandNode = (IfElseNode)soyNode;
                object = genJsExprsVisitor.exec(abstractParentSoyCommandNode);
                stringBuilder.append(JsExprUtils.concatJsExprs((List<JsExpr>)object).getText());
                continue;
            }
            throw new AssertionError();
        }
        if (!bl) {
            stringBuilder.append("''");
        }
        this.jsExprs.add(new JsExpr(stringBuilder.toString(), Operator.CONDITIONAL.getPrecedence()));
    }

    @Override
    protected void visitInternal(IfCondNode ifCondNode) {
        this.visitChildren(ifCondNode);
    }

    @Override
    protected void visitInternal(IfElseNode ifElseNode) {
        this.visitChildren(ifElseNode);
    }

    @Override
    protected void visitInternal(CallNode callNode) {
        this.jsExprs.add(this.genCallCodeUtils.genCallExpr(callNode, this.localVarTranslations));
    }

    @Override
    protected void visitInternal(CallParamContentNode callParamContentNode) {
        this.visitChildren(callParamContentNode);
    }

    public static interface GenJsExprsVisitorFactory {
        public GenJsExprsVisitor create(Deque<Map<String, JsExpr>> var1);
    }
}

