/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.jssrc.internal.FindCalleesNotInFileVisitor;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsCodeBuilder;
import com.google.template.soy.jssrc.internal.JsExprTranslator;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import com.google.template.soy.soytree.AbstractParentSoyCommandNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachIfemptyNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoytreeUtils;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.jssrc.GoogMsgNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class GenJsCodeVisitor
extends AbstractSoyNodeVisitor<List<String>> {
    private static final Pattern DOT = Pattern.compile("\\.");
    private static final Pattern INTEGER = Pattern.compile("-?\\d+");
    private static final Pattern UNDERSCORE_NUMBER_SUFFIX = Pattern.compile("_[0-9]+$");
    private final SoyJsSrcOptions jsSrcOptions;
    private final JsExprTranslator jsExprTranslator;
    private final GenCallCodeUtils genCallCodeUtils;
    private final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final CanInitOutputVarVisitor canInitOutputVarVisitor;
    private final GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory;
    private List<String> jsFilesContents;
    @VisibleForTesting
    protected GenJsExprsVisitor genJsExprsVisitor;
    @VisibleForTesting
    protected JsCodeBuilder jsCodeBuilder;
    @VisibleForTesting
    protected Deque<Map<String, JsExpr>> localVarTranslations;

    @Inject
    GenJsCodeVisitor(SoyJsSrcOptions soyJsSrcOptions, JsExprTranslator jsExprTranslator, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, CanInitOutputVarVisitor canInitOutputVarVisitor, GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory) {
        this.jsSrcOptions = soyJsSrcOptions;
        this.jsExprTranslator = jsExprTranslator;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.canInitOutputVarVisitor = canInitOutputVarVisitor;
        this.genJsExprsVisitorFactory = genJsExprsVisitorFactory;
    }

    @Override
    protected void setup() {
        this.jsFilesContents = Lists.newArrayList();
        this.jsCodeBuilder = null;
        this.localVarTranslations = null;
    }

    @Override
    @VisibleForTesting
    protected void visit(SoyNode soyNode) {
        super.visit(soyNode);
    }

    @Override
    protected List<String> getResult() {
        return this.jsFilesContents;
    }

    @Override
    protected void visitChildren(SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode) {
        if (parentSoyNode.numChildren() == 0 || !((Boolean)this.canInitOutputVarVisitor.exec(parentSoyNode.getChild(0))).booleanValue()) {
            this.jsCodeBuilder.initOutputVarIfNecessary();
        }
        ArrayList arrayList = Lists.newArrayList();
        for (SoyNode soyNode : parentSoyNode.getChildren()) {
            if (((Boolean)this.isComputableAsJsExprsVisitor.exec(soyNode)).booleanValue()) {
                arrayList.addAll(this.genJsExprsVisitor.exec(soyNode));
                continue;
            }
            if (arrayList.size() > 0) {
                this.jsCodeBuilder.addToOutputVar(arrayList);
                arrayList.clear();
            }
            this.visit(soyNode);
        }
        if (arrayList.size() > 0) {
            this.jsCodeBuilder.addToOutputVar(arrayList);
            arrayList.clear();
        }
    }

    @Override
    protected void visitInternal(SoyFileSetNode soyFileSetNode) {
        for (SoyFileNode soyFileNode : soyFileSetNode.getChildren()) {
            try {
                this.visit(soyFileNode);
            }
            catch (SoySyntaxException soySyntaxException) {
                throw soySyntaxException.setFilePath(soyFileNode.getFilePath());
            }
        }
    }

    @Override
    protected void visitInternal(SoyFileNode soyFileNode) {
        this.jsCodeBuilder = new JsCodeBuilder(this.jsSrcOptions.getCodeStyle());
        this.jsCodeBuilder.appendLine("// This file was automatically generated from ", soyFileNode.getFileName(), ".");
        this.jsCodeBuilder.appendLine("// Please don't edit this file by hand.");
        this.jsCodeBuilder.appendLine(new String[0]);
        if (this.jsSrcOptions.shouldProvideRequireSoyNamespaces()) {
            this.addCodeToProvideRequireSoyNamespaces(soyFileNode);
        } else if (this.jsSrcOptions.shouldProvideRequireJsFunctions()) {
            this.addCodeToProvideRequireJsFunctions(soyFileNode);
        } else {
            this.addCodeToDefineJsNamespaces(soyFileNode);
        }
        for (TemplateNode templateNode : soyFileNode.getChildren()) {
            this.jsCodeBuilder.appendLine(new String[0]).appendLine(new String[0]);
            try {
                this.visit(templateNode);
            }
            catch (SoySyntaxException soySyntaxException) {
                throw soySyntaxException.setTemplateName(templateNode.getTemplateName());
            }
        }
        this.jsFilesContents.add(this.jsCodeBuilder.getCode());
        this.jsCodeBuilder = null;
    }

    private void addCodeToDefineJsNamespaces(SoyFileNode soyFileNode) {
        TreeSet treeSet = Sets.newTreeSet();
        for (Object object : soyFileNode.getChildren()) {
            String string = ((TemplateNode)object).getTemplateName();
            Matcher matcher = DOT.matcher(string);
            while (matcher.find()) {
                treeSet.add(string.substring(0, matcher.start()));
            }
        }
        for (Object object : treeSet) {
            boolean bl;
            boolean bl2 = bl = ((String)object).indexOf(46) >= 0;
            if (!this.jsSrcOptions.shouldDeclareTopLevelNamespaces() && !bl) continue;
            this.jsCodeBuilder.appendLine(new String[]{"if (typeof ", object, " == 'undefined') { ", bl ? "" : "var ", object, " = {}; }"});
        }
    }

    private void addCodeToProvideRequireSoyNamespaces(SoyFileNode soyFileNode) {
        this.jsCodeBuilder.appendLine("goog.provide('", soyFileNode.getNamespace(), "');");
        this.jsCodeBuilder.appendLine(new String[0]);
        this.jsCodeBuilder.appendLine("goog.require('soy');");
        if (this.jsSrcOptions.getCodeStyle() == SoyJsSrcOptions.CodeStyle.STRINGBUILDER) {
            this.jsCodeBuilder.appendLine("goog.require('soy.StringBuilder');");
        }
        String string = null;
        for (String string2 : (Set)new FindCalleesNotInFileVisitor().exec(soyFileNode)) {
            int n = string2.lastIndexOf(46);
            if (n == -1) {
                throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo("When using the option to provide/require Soy namespaces, found a called template \"" + string2 + "\" that does not reside in a namespace.", null, soyFileNode);
            }
            String string3 = string2.substring(0, n);
            if (string3.length() <= 0 || string3.equals(string)) continue;
            this.jsCodeBuilder.appendLine("goog.require('", string3, "');");
            string = string3;
        }
    }

    private void addCodeToProvideRequireJsFunctions(SoyFileNode soyFileNode) {
        TreeSet treeSet = Sets.newTreeSet();
        for (Object object : soyFileNode.getChildren()) {
            if (((TemplateNode)object).isOverride()) continue;
            treeSet.add(((TemplateNode)object).getTemplateName());
        }
        for (Object object : treeSet) {
            this.jsCodeBuilder.appendLine(new String[]{"goog.provide('", object, "');"});
        }
        this.jsCodeBuilder.appendLine(new String[0]);
        this.jsCodeBuilder.appendLine("goog.require('soy');");
        if (this.jsSrcOptions.getCodeStyle() == SoyJsSrcOptions.CodeStyle.STRINGBUILDER) {
            this.jsCodeBuilder.appendLine("goog.require('soy.StringBuilder');");
        }
        for (Object object : (Set)new FindCalleesNotInFileVisitor().exec(soyFileNode)) {
            this.jsCodeBuilder.appendLine(new String[]{"goog.require('", object, "');"});
        }
    }

    @Override
    protected void visitInternal(TemplateNode templateNode) {
        boolean bl = this.jsSrcOptions.getCodeStyle() == SoyJsSrcOptions.CodeStyle.STRINGBUILDER;
        this.localVarTranslations = new ArrayDeque<Map<String, JsExpr>>();
        this.genJsExprsVisitor = this.genJsExprsVisitorFactory.create(this.localVarTranslations);
        if (this.jsSrcOptions.shouldGenerateJsdoc()) {
            this.jsCodeBuilder.appendLine("/**");
            this.jsCodeBuilder.appendLine(" * @param {Object.<string, *>=} opt_data");
            if (bl) {
                this.jsCodeBuilder.appendLine(" * @param {soy.StringBuilder=} opt_sb");
                this.jsCodeBuilder.appendLine(" * @return {string|undefined}");
            } else {
                this.jsCodeBuilder.appendLine(" * @return {string}");
            }
            this.jsCodeBuilder.appendLine(" * @notypecheck");
            this.jsCodeBuilder.appendLine(" */");
        }
        if (bl) {
            this.jsCodeBuilder.appendLine(templateNode.getTemplateName(), " = function(opt_data, opt_sb) {");
        } else {
            this.jsCodeBuilder.appendLine(templateNode.getTemplateName(), " = function(opt_data) {");
        }
        this.jsCodeBuilder.increaseIndent();
        this.localVarTranslations.push(Maps.newHashMap());
        if (!bl && ((Boolean)this.isComputableAsJsExprsVisitor.exec(templateNode)).booleanValue()) {
            List<JsExpr> list = this.genJsExprsVisitor.exec(templateNode);
            JsExpr jsExpr = JsExprUtils.concatJsExprs(list);
            this.jsCodeBuilder.appendLine("return ", jsExpr.getText(), ";");
        } else {
            this.jsCodeBuilder.pushOutputVar("output");
            if (bl) {
                this.jsCodeBuilder.appendLine("var output = opt_sb || new soy.StringBuilder();");
                this.jsCodeBuilder.setOutputVarInited();
            }
            this.visitChildren(templateNode);
            if (bl) {
                this.jsCodeBuilder.appendLine("if (!opt_sb) return output.toString();");
            } else {
                this.jsCodeBuilder.appendLine("return output;");
            }
            this.jsCodeBuilder.popOutputVar();
        }
        this.localVarTranslations.pop();
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("};");
    }

    @Override
    protected void visitInternal(GoogMsgNode googMsgNode) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        for (SoyNode soyNode : googMsgNode.getChildren()) {
            Object object;
            if (soyNode instanceof RawTextNode) {
                stringBuilder.append(((RawTextNode)soyNode).getRawText());
                continue;
            }
            if (soyNode instanceof SoyNode.MsgPlaceholderNode) {
                object = googMsgNode.getPlaceholderName((SoyNode.MsgPlaceholderNode)soyNode);
                String string = this.genGoogMsgPlaceholderName((String)object);
                stringBuilder.append("{$").append(string).append("}");
                if (hashSet.contains(object)) continue;
                hashSet.add((String)object);
                String string2 = "'" + string + "': " + this.genGoogMsgPlaceholderExpr((SoyNode.MsgPlaceholderNode)soyNode).getText();
                arrayList.add(string2);
                continue;
            }
            object = googMsgNode instanceof SoyNode.SoyCommandNode ? "Tag " + ((SoyNode.SoyCommandNode)((Object)googMsgNode)).getTagString() : "Node " + googMsgNode.toString();
            throw new SoySyntaxException((String)object + " is not allowed to be a direct child of a 'msg' tag.");
        }
        Object object = BaseUtils.escapeToSoyString(stringBuilder.toString(), false);
        object = JsSrcUtils.escapeUnicodeFormatChars((String)object);
        this.jsCodeBuilder.indent().append("/** @desc ", googMsgNode.getDesc());
        if (googMsgNode.isHidden()) {
            this.jsCodeBuilder.append("\n");
            this.jsCodeBuilder.indent().append(" *  @hidden");
        }
        this.jsCodeBuilder.append(" */\n");
        this.jsCodeBuilder.indent().append("var ", googMsgNode.getGoogMsgName(), " = goog.getMsg(");
        if (arrayList.size() == 0) {
            this.jsCodeBuilder.append(new String[]{object});
        } else {
            this.jsCodeBuilder.append("\n");
            this.jsCodeBuilder.indent().append(new String[]{"    ", object});
            boolean bl = true;
            for (String string : arrayList) {
                this.jsCodeBuilder.append(",\n");
                if (bl) {
                    bl = false;
                    this.jsCodeBuilder.indent().append("    {");
                } else {
                    this.jsCodeBuilder.indent().append("     ");
                }
                this.jsCodeBuilder.append(string);
            }
            this.jsCodeBuilder.append("}");
        }
        this.jsCodeBuilder.append(");\n");
    }

    private String genGoogMsgPlaceholderName(String string) {
        Matcher matcher = UNDERSCORE_NUMBER_SUFFIX.matcher(string);
        if (matcher.find()) {
            String string2 = string.substring(0, matcher.start());
            String string3 = matcher.group();
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, string2) + string3;
        }
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, string);
    }

    private JsExpr genGoogMsgPlaceholderExpr(SoyNode.MsgPlaceholderNode msgPlaceholderNode) {
        if (msgPlaceholderNode instanceof MsgHtmlTagNode && !((Boolean)this.isComputableAsJsExprsVisitor.exec(msgPlaceholderNode)).booleanValue()) {
            this.visit(msgPlaceholderNode);
            return new JsExpr("htmlTag" + msgPlaceholderNode.getId(), Integer.MAX_VALUE);
        }
        if (msgPlaceholderNode instanceof CallNode) {
            CallNode callNode = (CallNode)msgPlaceholderNode;
            for (CallParamNode callParamNode : callNode.getChildren()) {
                if (!(callParamNode instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(callParamNode)).booleanValue()) continue;
                this.visit(callParamNode);
            }
            return this.genCallCodeUtils.genCallExpr(callNode, this.localVarTranslations);
        }
        return JsExprUtils.concatJsExprs(this.genJsExprsVisitor.exec(msgPlaceholderNode));
    }

    @Override
    protected void visitInternal(MsgHtmlTagNode msgHtmlTagNode) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(msgHtmlTagNode)).booleanValue()) {
            throw new AssertionError((Object)"Should only define 'htmlTag<n>' when not computable as JS expressions.");
        }
        this.jsCodeBuilder.pushOutputVar("htmlTag" + msgHtmlTagNode.getId());
        this.visitChildren(msgHtmlTagNode);
        this.jsCodeBuilder.popOutputVar();
    }

    @Override
    protected void visitInternal(PrintNode printNode) {
        this.jsCodeBuilder.addToOutputVar(this.genJsExprsVisitor.exec(printNode));
    }

    @Override
    protected void visitInternal(IfNode ifNode) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(ifNode)).booleanValue()) {
            this.jsCodeBuilder.addToOutputVar(this.genJsExprsVisitor.exec(ifNode));
            return;
        }
        for (SoyNode soyNode : ifNode.getChildren()) {
            AbstractParentSoyCommandNode abstractParentSoyCommandNode;
            if (soyNode instanceof IfCondNode) {
                abstractParentSoyCommandNode = (IfCondNode)soyNode;
                JsExpr jsExpr = this.jsExprTranslator.translateToJsExpr(((IfCondNode)abstractParentSoyCommandNode).getExpr(), ((IfCondNode)abstractParentSoyCommandNode).getExprText(), this.localVarTranslations);
                if (abstractParentSoyCommandNode.getCommandName().equals("if")) {
                    this.jsCodeBuilder.appendLine("if (", jsExpr.getText(), ") {");
                } else {
                    this.jsCodeBuilder.appendLine("} else if (", jsExpr.getText(), ") {");
                }
                this.jsCodeBuilder.increaseIndent();
                this.visit(abstractParentSoyCommandNode);
                this.jsCodeBuilder.decreaseIndent();
                continue;
            }
            if (soyNode instanceof IfElseNode) {
                abstractParentSoyCommandNode = (IfElseNode)soyNode;
                this.jsCodeBuilder.appendLine("} else {");
                this.jsCodeBuilder.increaseIndent();
                this.visit(abstractParentSoyCommandNode);
                this.jsCodeBuilder.decreaseIndent();
                continue;
            }
            throw new AssertionError();
        }
        this.jsCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitInternal(SwitchNode switchNode) {
        JsExpr jsExpr = this.jsExprTranslator.translateToJsExpr(switchNode.getExpr(), switchNode.getExprText(), this.localVarTranslations);
        this.jsCodeBuilder.appendLine("switch (", jsExpr.getText(), ") {");
        this.jsCodeBuilder.increaseIndent();
        for (SoyNode soyNode : switchNode.getChildren()) {
            AbstractParentSoyCommandNode abstractParentSoyCommandNode;
            if (soyNode instanceof SwitchCaseNode) {
                abstractParentSoyCommandNode = (SwitchCaseNode)soyNode;
                for (ExprRootNode<ExprNode> exprRootNode : abstractParentSoyCommandNode.getExprList()) {
                    JsExpr jsExpr2 = this.jsExprTranslator.translateToJsExpr(exprRootNode, null, this.localVarTranslations);
                    this.jsCodeBuilder.appendLine("case ", jsExpr2.getText(), ":");
                }
                this.jsCodeBuilder.increaseIndent();
                this.visit(abstractParentSoyCommandNode);
                this.jsCodeBuilder.appendLine("break;");
                this.jsCodeBuilder.decreaseIndent();
                continue;
            }
            if (soyNode instanceof SwitchDefaultNode) {
                abstractParentSoyCommandNode = (SwitchDefaultNode)soyNode;
                this.jsCodeBuilder.appendLine("default:");
                this.jsCodeBuilder.increaseIndent();
                this.visit(abstractParentSoyCommandNode);
                this.jsCodeBuilder.decreaseIndent();
                continue;
            }
            throw new AssertionError();
        }
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitInternal(ForeachNode foreachNode) {
        boolean bl;
        String string = foreachNode.getVarName();
        String string2 = foreachNode.getId();
        String string3 = string + "List" + string2;
        String string4 = string + "ListLen" + string2;
        JsExpr jsExpr = this.jsExprTranslator.translateToJsExpr(foreachNode.getDataRef(), foreachNode.getDataRefText(), this.localVarTranslations);
        this.jsCodeBuilder.appendLine("var ", string3, " = ", jsExpr.getText(), ";");
        this.jsCodeBuilder.appendLine("var ", string4, " = ", string3, ".length;");
        boolean bl2 = bl = foreachNode.numChildren() == 2;
        if (bl) {
            this.jsCodeBuilder.appendLine("if (", string4, " > 0) {");
            this.jsCodeBuilder.increaseIndent();
        }
        this.visit((ForeachNonemptyNode)foreachNode.getChild(0));
        if (bl) {
            this.jsCodeBuilder.decreaseIndent();
            this.jsCodeBuilder.appendLine("} else {");
            this.jsCodeBuilder.increaseIndent();
            this.visit((ForeachIfemptyNode)foreachNode.getChild(1));
            this.jsCodeBuilder.decreaseIndent();
            this.jsCodeBuilder.appendLine("}");
        }
    }

    @Override
    protected void visitInternal(ForeachNonemptyNode foreachNonemptyNode) {
        String string = foreachNonemptyNode.getVarName();
        String string2 = foreachNonemptyNode.getForeachNodeId();
        String string3 = string + "List" + string2;
        String string4 = string + "ListLen" + string2;
        String string5 = string + "Index" + string2;
        String string6 = string + "Data" + string2;
        this.jsCodeBuilder.appendLine("for (var ", string5, " = 0; ", string5, " < ", string4, "; ", string5, "++) {");
        this.jsCodeBuilder.increaseIndent();
        this.jsCodeBuilder.appendLine("var ", string6, " = ", string3, "[", string5, "];");
        HashMap hashMap = Maps.newHashMap();
        hashMap.put(string, new JsExpr(string6, Integer.MAX_VALUE));
        hashMap.put(string + "__isFirst", new JsExpr(string5 + " == 0", Operator.EQUAL.getPrecedence()));
        hashMap.put(string + "__isLast", new JsExpr(string5 + " == " + string4 + " - 1", Operator.EQUAL.getPrecedence()));
        hashMap.put(string + "__index", new JsExpr(string5, Integer.MAX_VALUE));
        this.localVarTranslations.push(hashMap);
        this.visitChildren(foreachNonemptyNode);
        this.localVarTranslations.pop();
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitInternal(ForNode forNode) {
        String string;
        String string2;
        String string3;
        String string4 = forNode.getLocalVarName();
        String string5 = forNode.getId();
        ArrayList arrayList = Lists.newArrayList(forNode.getRangeArgs());
        String string6 = arrayList.size() == 3 ? this.jsExprTranslator.translateToJsExpr((ExprNode)arrayList.remove(2), null, this.localVarTranslations).getText() : "1";
        String string7 = arrayList.size() == 2 ? this.jsExprTranslator.translateToJsExpr((ExprNode)arrayList.remove(0), null, this.localVarTranslations).getText() : "0";
        String string8 = this.jsExprTranslator.translateToJsExpr((ExprNode)arrayList.get(0), null, this.localVarTranslations).getText();
        if (INTEGER.matcher(string7).matches()) {
            string3 = string7;
        } else {
            string3 = string4 + "Init" + string5;
            this.jsCodeBuilder.appendLine("var ", string3, " = ", string7, ";");
        }
        if (INTEGER.matcher(string8).matches()) {
            string2 = string8;
        } else {
            string2 = string4 + "Limit" + string5;
            this.jsCodeBuilder.appendLine("var ", string2, " = ", string8, ";");
        }
        if (INTEGER.matcher(string6).matches()) {
            string = string6;
        } else {
            string = string4 + "Increment" + string5;
            this.jsCodeBuilder.appendLine("var ", string, " = ", string6, ";");
        }
        String string9 = string.equals("1") ? string4 + string5 + "++" : string4 + string5 + " += " + string;
        this.jsCodeBuilder.appendLine("for (var ", string4, string5, " = ", string3, "; ", string4, string5, " < ", string2, "; ", string9, ") {");
        this.jsCodeBuilder.increaseIndent();
        HashMap hashMap = Maps.newHashMap();
        hashMap.put(string4, new JsExpr(string4 + string5, Integer.MAX_VALUE));
        this.localVarTranslations.push(hashMap);
        this.visitChildren(forNode);
        this.localVarTranslations.pop();
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitInternal(CallNode callNode) {
        Object object;
        for (CallParamNode callParamNode : callNode.getChildren()) {
            if (!(callParamNode instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(callParamNode)).booleanValue()) continue;
            this.visit(callParamNode);
        }
        if (this.jsSrcOptions.getCodeStyle() == SoyJsSrcOptions.CodeStyle.STRINGBUILDER) {
            object = this.genCallCodeUtils.genObjToPass(callNode, this.localVarTranslations);
            this.jsCodeBuilder.indent().append(callNode.getCalleeName(), "(", ((JsExpr)object).getText(), ", ").appendOutputVarName().append(");\n");
        } else {
            object = this.genCallCodeUtils.genCallExpr(callNode, this.localVarTranslations);
            this.jsCodeBuilder.addToOutputVar((List<JsExpr>)ImmutableList.of((Object)object));
        }
    }

    @Override
    protected void visitInternal(CallParamContentNode callParamContentNode) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(callParamContentNode)).booleanValue()) {
            throw new AssertionError((Object)"Should only define 'param<n>' when not computable as JS expressions.");
        }
        this.localVarTranslations.push(Maps.newHashMap());
        this.jsCodeBuilder.pushOutputVar("param" + callParamContentNode.getId());
        this.visitChildren(callParamContentNode);
        this.jsCodeBuilder.popOutputVar();
        this.localVarTranslations.pop();
    }

    @Override
    protected void visitInternal(SoyNode soyNode) {
        if (!((Boolean)this.isComputableAsJsExprsVisitor.exec(soyNode)).booleanValue()) {
            throw new UnsupportedOperationException();
        }
        this.jsCodeBuilder.addToOutputVar(this.genJsExprsVisitor.exec(soyNode));
    }

    @Override
    protected void visitInternal(SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode) {
        this.localVarTranslations.push(Maps.newHashMap());
        this.visitChildren(parentSoyNode);
        this.localVarTranslations.pop();
    }
}

