/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.inject.Inject;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsExprTranslator;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import java.util.Deque;
import java.util.List;
import java.util.Map;

class GenCallCodeUtils {
    private final SoyJsSrcOptions jsSrcOptions;
    private final JsExprTranslator jsExprTranslator;
    private final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory;

    @Inject
    GenCallCodeUtils(SoyJsSrcOptions soyJsSrcOptions, JsExprTranslator jsExprTranslator, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory) {
        this.jsSrcOptions = soyJsSrcOptions;
        this.jsExprTranslator = jsExprTranslator;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.genJsExprsVisitorFactory = genJsExprsVisitorFactory;
    }

    public JsExpr genCallExpr(CallNode callNode, Deque<Map<String, JsExpr>> deque) {
        JsExpr jsExpr = this.genObjToPass(callNode, deque);
        return new JsExpr(callNode.getCalleeName() + "(" + jsExpr.getText() + ")", Integer.MAX_VALUE);
    }

    public JsExpr genObjToPass(CallNode callNode, Deque<Map<String, JsExpr>> deque) {
        JsExpr jsExpr = callNode.isPassingAllData() ? new JsExpr("opt_data", Integer.MAX_VALUE) : (callNode.isPassingData() ? this.jsExprTranslator.translateToJsExpr(callNode.getDataRef(), callNode.getDataRefText(), deque) : new JsExpr("null", Integer.MAX_VALUE));
        if (callNode.numChildren() == 0) {
            return jsExpr;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        boolean bl = true;
        for (CallParamNode callParamNode : callNode.getChildren()) {
            Object object;
            CallParamNode callParamNode2;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            String string = callParamNode.getKey();
            stringBuilder.append(string).append(": ");
            if (callParamNode instanceof CallParamValueNode) {
                callParamNode2 = (CallParamValueNode)callParamNode;
                object = this.jsExprTranslator.translateToJsExpr(((CallParamValueNode)callParamNode2).getValueExpr(), ((CallParamValueNode)callParamNode2).getValueExprText(), deque);
                stringBuilder.append(((JsExpr)object).getText());
                continue;
            }
            callParamNode2 = (CallParamContentNode)callParamNode;
            if (((Boolean)this.isComputableAsJsExprsVisitor.exec(callParamNode2)).booleanValue()) {
                object = this.genJsExprsVisitorFactory.create(deque).exec(callParamNode2);
                JsExpr jsExpr2 = JsExprUtils.concatJsExprs((List<JsExpr>)object);
                stringBuilder.append(jsExpr2.getText());
                continue;
            }
            if (this.jsSrcOptions.getCodeStyle() == SoyJsSrcOptions.CodeStyle.STRINGBUILDER) {
                stringBuilder.append("param").append(callParamNode2.getId()).append(".toString()");
                continue;
            }
            stringBuilder.append("param").append(callParamNode2.getId());
        }
        stringBuilder.append("}");
        if (callNode.isPassingData()) {
            return new JsExpr("soy.$$augmentData(" + jsExpr.getText() + ", " + stringBuilder.toString() + ")", Integer.MAX_VALUE);
        }
        return new JsExpr(stringBuilder.toString(), Integer.MAX_VALUE);
    }
}

