/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.internal;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.javasrc.SoyJavaSrcOptions;
import com.google.template.soy.javasrc.internal.GenJavaCodeVisitor;
import com.google.template.soy.javasrc.internal.OptimizeBidiCodeGenVisitor;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.InsertMsgsVisitor;
import com.google.template.soy.shared.internal.ApiCallScopeUtils;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.soytree.SoyFileSetNode;
import javax.annotation.Nullable;

public class JavaSrcMain {
    private final GuiceSimpleScope apiCallScope;
    private final Provider<OptimizeBidiCodeGenVisitor> optimizeBidiCodeGenVisitorProvider;
    private final Provider<GenJavaCodeVisitor> genJavaCodeVisitorProvider;

    @Inject
    JavaSrcMain(@ApiCallScopeBindingAnnotations.ApiCall GuiceSimpleScope guiceSimpleScope, Provider<OptimizeBidiCodeGenVisitor> provider, Provider<GenJavaCodeVisitor> provider2) {
        this.apiCallScope = guiceSimpleScope;
        this.optimizeBidiCodeGenVisitorProvider = provider;
        this.genJavaCodeVisitorProvider = provider2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String genJavaSrc(SoyFileSetNode soyFileSetNode, SoyJavaSrcOptions soyJavaSrcOptions, @Nullable SoyMsgBundle soyMsgBundle) throws SoySyntaxException {
        new InsertMsgsVisitor(soyMsgBundle).exec(soyFileSetNode);
        this.apiCallScope.enter();
        try {
            this.apiCallScope.seed(SoyJavaSrcOptions.class, soyJavaSrcOptions);
            ApiCallScopeUtils.seedSharedParams(this.apiCallScope, soyMsgBundle, soyJavaSrcOptions.getBidiGlobalDir());
            ((OptimizeBidiCodeGenVisitor)this.optimizeBidiCodeGenVisitorProvider.get()).exec(soyFileSetNode);
            String string = (String)((GenJavaCodeVisitor)this.genJavaCodeVisitorProvider.get()).exec(soyFileSetNode);
            return string;
        }
        finally {
            this.apiCallScope.exit();
        }
    }
}

