/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.internal;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.template.soy.javasrc.SoyJavaSrcOptions;
import com.google.template.soy.shared.internal.ApiCallScope;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;

@ApiCallScope
class IsComputableAsJavaExprsVisitor
extends AbstractSoyNodeVisitor<Boolean> {
    private final SoyJavaSrcOptions javaSrcOptions;
    private final Map<SoyNode, Boolean> memoizedResults;
    private Deque<Boolean> resultStack;

    @Inject
    public IsComputableAsJavaExprsVisitor(SoyJavaSrcOptions soyJavaSrcOptions) {
        this.javaSrcOptions = soyJavaSrcOptions;
        this.memoizedResults = Maps.newHashMap();
    }

    @Override
    protected void setup() {
        this.resultStack = new ArrayDeque<Boolean>();
    }

    @Override
    protected void visit(SoyNode soyNode) {
        if (this.memoizedResults.containsKey(soyNode)) {
            this.resultStack.push(this.memoizedResults.get(soyNode));
        } else {
            super.visit(soyNode);
            this.memoizedResults.put(soyNode, this.resultStack.peek());
        }
    }

    @Override
    protected Boolean getResult() {
        return this.resultStack.peek();
    }

    @Override
    protected void visitInternal(TemplateNode templateNode) {
        this.resultStack.push(this.areChildrenComputableAsJavaExprs(templateNode));
    }

    @Override
    protected void visitInternal(RawTextNode rawTextNode) {
        this.resultStack.push(true);
    }

    @Override
    protected void visitInternal(MsgHtmlTagNode msgHtmlTagNode) {
        this.resultStack.push(this.areChildrenComputableAsJavaExprs(msgHtmlTagNode));
    }

    @Override
    protected void visitInternal(PrintNode printNode) {
        this.resultStack.push(true);
    }

    @Override
    protected void visitInternal(CssNode cssNode) {
        this.resultStack.push(true);
    }

    @Override
    protected void visitInternal(IfNode ifNode) {
        this.resultStack.push(this.areChildrenComputableAsJavaExprs(ifNode));
    }

    @Override
    protected void visitInternal(IfCondNode ifCondNode) {
        this.resultStack.push(this.areChildrenComputableAsJavaExprs(ifCondNode));
    }

    @Override
    protected void visitInternal(IfElseNode ifElseNode) {
        this.resultStack.push(this.areChildrenComputableAsJavaExprs(ifElseNode));
    }

    @Override
    protected void visitInternal(SwitchNode switchNode) {
        this.resultStack.push(false);
    }

    @Override
    protected void visitInternal(ForeachNode foreachNode) {
        this.resultStack.push(false);
    }

    @Override
    protected void visitInternal(ForNode forNode) {
        this.resultStack.push(false);
    }

    @Override
    protected void visitInternal(CallNode callNode) {
        this.resultStack.push(this.javaSrcOptions.getCodeStyle() == SoyJavaSrcOptions.CodeStyle.CONCAT && this.areChildrenComputableAsJavaExprs(callNode));
    }

    @Override
    protected void visitInternal(CallParamValueNode callParamValueNode) {
        this.resultStack.push(true);
    }

    @Override
    protected void visitInternal(CallParamContentNode callParamContentNode) {
        this.resultStack.push(this.areChildrenComputableAsJavaExprs(callParamContentNode));
    }

    private boolean areChildrenComputableAsJavaExprs(SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode) {
        for (SoyNode soyNode : parentSoyNode.getChildren()) {
            if (soyNode instanceof RawTextNode || soyNode instanceof PrintNode) continue;
            this.visit(soyNode);
            boolean bl = this.resultStack.pop();
            if (bl) continue;
            return false;
        }
        return true;
    }
}

