/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.internal.base.CharEscapers;
import com.google.template.soy.javasrc.internal.GenCallCodeUtils;
import com.google.template.soy.javasrc.internal.IsComputableAsJavaExprsVisitor;
import com.google.template.soy.javasrc.internal.TranslateToJavaExprVisitor;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.JavaExprUtils;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcPrintDirective;
import com.google.template.soy.soytree.AbstractParentSoyCommandNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;

public class GenJavaExprsVisitor
extends AbstractSoyNodeVisitor<List<JavaExpr>> {
    Map<String, SoyJavaSrcPrintDirective> soyJavaSrcDirectivesMap;
    private final GenCallCodeUtils genCallCodeUtils;
    private final IsComputableAsJavaExprsVisitor isComputableAsJavaExprsVisitor;
    private final GenJavaExprsVisitorFactory genJavaExprsVisitorFactory;
    private final TranslateToJavaExprVisitor.TranslateToJavaExprVisitorFactory translateToJavaExprVisitorFactory;
    private final Deque<Map<String, JavaExpr>> localVarTranslations;
    private List<JavaExpr> javaExprs;

    @AssistedInject
    GenJavaExprsVisitor(Map<String, SoyJavaSrcPrintDirective> map, GenCallCodeUtils genCallCodeUtils, IsComputableAsJavaExprsVisitor isComputableAsJavaExprsVisitor, GenJavaExprsVisitorFactory genJavaExprsVisitorFactory, TranslateToJavaExprVisitor.TranslateToJavaExprVisitorFactory translateToJavaExprVisitorFactory, @Assisted Deque<Map<String, JavaExpr>> deque) {
        this.soyJavaSrcDirectivesMap = map;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJavaExprsVisitor = isComputableAsJavaExprsVisitor;
        this.genJavaExprsVisitorFactory = genJavaExprsVisitorFactory;
        this.translateToJavaExprVisitorFactory = translateToJavaExprVisitorFactory;
        this.localVarTranslations = deque;
    }

    @Override
    public List<JavaExpr> exec(SoyNode soyNode) {
        Preconditions.checkArgument((boolean)((Boolean)this.isComputableAsJavaExprsVisitor.exec(soyNode)));
        return (List)super.exec(soyNode);
    }

    @Override
    protected void setup() {
        this.javaExprs = Lists.newArrayList();
    }

    @Override
    protected List<JavaExpr> getResult() {
        return this.javaExprs;
    }

    @Override
    protected void visitInternal(TemplateNode templateNode) {
        this.visitChildren(templateNode);
    }

    @Override
    protected void visitInternal(RawTextNode rawTextNode) {
        this.javaExprs.add(new JavaExpr('\"' + CharEscapers.javaStringEscaper().escape(rawTextNode.getRawText()) + '\"', String.class, Integer.MAX_VALUE));
    }

    @Override
    protected void visitInternal(PrintNode printNode) {
        TranslateToJavaExprVisitor translateToJavaExprVisitor = this.translateToJavaExprVisitorFactory.create(this.localVarTranslations);
        JavaExpr javaExpr = (JavaExpr)translateToJavaExprVisitor.exec(printNode.getExpr());
        for (PrintDirectiveNode printDirectiveNode : printNode.getChildren()) {
            SoyJavaSrcPrintDirective soyJavaSrcPrintDirective = this.soyJavaSrcDirectivesMap.get(printDirectiveNode.getName());
            if (soyJavaSrcPrintDirective == null) {
                throw new SoySyntaxException("Failed to find SoyJavaSrcPrintDirective with name '" + printDirectiveNode.getName() + "'" + " (tag " + printNode.toSourceString() + ")");
            }
            List<ExprRootNode<ExprNode>> list = printDirectiveNode.getArgs();
            if (!soyJavaSrcPrintDirective.getValidArgsSizes().contains(list.size())) {
                throw new SoySyntaxException("Print directive '" + printDirectiveNode.getName() + "' used with the wrong number of" + " arguments (tag " + printNode.toSourceString() + ").");
            }
            ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
            for (ExprRootNode<ExprNode> exprRootNode : list) {
                arrayList.add(translateToJavaExprVisitor.exec(exprRootNode));
            }
            javaExpr = soyJavaSrcPrintDirective.applyForJavaSrc(javaExpr, arrayList);
        }
        this.javaExprs.add(javaExpr);
    }

    @Override
    protected void visitInternal(IfNode ifNode) {
        GenJavaExprsVisitor genJavaExprsVisitor = this.genJavaExprsVisitorFactory.create(this.localVarTranslations);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (SoyNode soyNode : ifNode.getChildren()) {
            Object object;
            AbstractParentSoyCommandNode abstractParentSoyCommandNode;
            if (soyNode instanceof IfCondNode) {
                abstractParentSoyCommandNode = (IfCondNode)soyNode;
                object = (JavaExpr)this.translateToJavaExprVisitorFactory.create(this.localVarTranslations).exec(((IfCondNode)abstractParentSoyCommandNode).getExpr());
                stringBuilder.append("(").append(JavaCodeUtils.genCoerceBoolean((JavaExpr)object)).append(") ? ");
                List<JavaExpr> list = genJavaExprsVisitor.exec(abstractParentSoyCommandNode);
                stringBuilder.append(JavaCodeUtils.genMaybeProtect(JavaExprUtils.concatJavaExprs(list), Operator.CONDITIONAL.getPrecedence() + 1));
                stringBuilder.append(" : ");
                continue;
            }
            if (soyNode instanceof IfElseNode) {
                bl = true;
                abstractParentSoyCommandNode = (IfElseNode)soyNode;
                object = genJavaExprsVisitor.exec(abstractParentSoyCommandNode);
                stringBuilder.append(JavaCodeUtils.genMaybeProtect(JavaExprUtils.concatJavaExprs((List<JavaExpr>)object), Operator.CONDITIONAL.getPrecedence() + 1));
                continue;
            }
            throw new AssertionError();
        }
        if (!bl) {
            stringBuilder.append("\"\"");
        }
        this.javaExprs.add(new JavaExpr(stringBuilder.toString(), String.class, Operator.CONDITIONAL.getPrecedence()));
    }

    @Override
    protected void visitInternal(IfCondNode ifCondNode) {
        this.visitChildren(ifCondNode);
    }

    @Override
    protected void visitInternal(IfElseNode ifElseNode) {
        this.visitChildren(ifElseNode);
    }

    @Override
    protected void visitInternal(CallNode callNode) {
        this.javaExprs.add(this.genCallCodeUtils.genCallExpr(callNode, this.localVarTranslations));
    }

    @Override
    protected void visitInternal(CallParamContentNode callParamContentNode) {
        this.visitChildren(callParamContentNode);
    }

    public static interface GenJavaExprsVisitorFactory {
        public GenJavaExprsVisitor create(Deque<Map<String, JavaExpr>> var1);
    }
}

