/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.internal;

import com.google.inject.Inject;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.javasrc.SoyJavaSrcOptions;
import com.google.template.soy.javasrc.internal.GenJavaExprsVisitor;
import com.google.template.soy.javasrc.internal.IsComputableAsJavaExprsVisitor;
import com.google.template.soy.javasrc.internal.TranslateToJavaExprVisitor;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.JavaExprUtils;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import java.util.Deque;
import java.util.List;
import java.util.Map;

class GenCallCodeUtils {
    private final SoyJavaSrcOptions javaSrcOptions;
    private final IsComputableAsJavaExprsVisitor isComputableAsJavaExprsVisitor;
    private final GenJavaExprsVisitor.GenJavaExprsVisitorFactory genJavaExprsVisitorFactory;
    private final TranslateToJavaExprVisitor.TranslateToJavaExprVisitorFactory translateToJavaExprVisitorFactory;

    @Inject
    GenCallCodeUtils(SoyJavaSrcOptions soyJavaSrcOptions, IsComputableAsJavaExprsVisitor isComputableAsJavaExprsVisitor, GenJavaExprsVisitor.GenJavaExprsVisitorFactory genJavaExprsVisitorFactory, TranslateToJavaExprVisitor.TranslateToJavaExprVisitorFactory translateToJavaExprVisitorFactory) {
        this.javaSrcOptions = soyJavaSrcOptions;
        this.isComputableAsJavaExprsVisitor = isComputableAsJavaExprsVisitor;
        this.genJavaExprsVisitorFactory = genJavaExprsVisitorFactory;
        this.translateToJavaExprVisitorFactory = translateToJavaExprVisitorFactory;
    }

    public JavaExpr genCallExpr(CallNode callNode, Deque<Map<String, JavaExpr>> deque) {
        JavaExpr javaExpr = this.genObjToPass(callNode, deque);
        return new JavaExpr(callNode.getCalleeName().replace('.', '$') + "(" + javaExpr.getText() + ")", String.class, Integer.MAX_VALUE);
    }

    public JavaExpr genObjToPass(CallNode callNode, Deque<Map<String, JavaExpr>> deque) {
        TranslateToJavaExprVisitor translateToJavaExprVisitor = this.translateToJavaExprVisitorFactory.create(deque);
        JavaExpr javaExpr = callNode.isPassingAllData() ? new JavaExpr("data", SoyMapData.class, Integer.MAX_VALUE) : (callNode.isPassingData() ? new JavaExpr(JavaCodeUtils.genMaybeCast((JavaExpr)translateToJavaExprVisitor.exec(callNode.getDataRef()), SoyMapData.class), SoyMapData.class, Integer.MAX_VALUE) : new JavaExpr("null", SoyMapData.class, Integer.MAX_VALUE));
        if (callNode.numChildren() == 0) {
            return javaExpr;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("new com.google.template.soy.data.SoyMapData(");
        boolean bl = true;
        for (CallParamNode callParamNode : callNode.getChildren()) {
            Object object;
            CallParamNode callParamNode2;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            String string = callParamNode.getKey();
            stringBuilder.append("\"").append(string).append("\", ");
            if (callParamNode instanceof CallParamValueNode) {
                callParamNode2 = (CallParamValueNode)callParamNode;
                object = (JavaExpr)translateToJavaExprVisitor.exec(((CallParamValueNode)callParamNode2).getValueExpr());
                stringBuilder.append(((JavaExpr)object).getText());
                continue;
            }
            callParamNode2 = (CallParamContentNode)callParamNode;
            if (((Boolean)this.isComputableAsJavaExprsVisitor.exec(callParamNode2)).booleanValue()) {
                object = this.genJavaExprsVisitorFactory.create(deque).exec(callParamNode2);
                JavaExpr javaExpr2 = JavaExprUtils.concatJavaExprs((List<JavaExpr>)object);
                stringBuilder.append(javaExpr2.getText());
                continue;
            }
            if (this.javaSrcOptions.getCodeStyle() == SoyJavaSrcOptions.CodeStyle.STRINGBUILDER) {
                stringBuilder.append("param").append(callParamNode2.getId()).append(".toString()");
                continue;
            }
            stringBuilder.append("param").append(callParamNode2.getId());
        }
        stringBuilder.append(")");
        if (callNode.isPassingData()) {
            return new JavaExpr(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$augmentData", javaExpr.getText(), stringBuilder.toString()), SoyMapData.class, Integer.MAX_VALUE);
        }
        return new JavaExpr(stringBuilder.toString(), SoyMapData.class, Integer.MAX_VALUE);
    }
}

