/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.internal;

import com.google.inject.Inject;
import com.google.template.soy.javasrc.SoyJavaSrcOptions;
import com.google.template.soy.javasrc.internal.IsComputableAsJavaExprsVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayDeque;
import java.util.Deque;

class CanInitOutputVarVisitor
extends AbstractSoyNodeVisitor<Boolean> {
    private final SoyJavaSrcOptions javaSrcOptions;
    private final IsComputableAsJavaExprsVisitor computableAsJavaExprsVisitor;
    private Deque<Boolean> resultStack;

    @Inject
    public CanInitOutputVarVisitor(SoyJavaSrcOptions soyJavaSrcOptions, IsComputableAsJavaExprsVisitor isComputableAsJavaExprsVisitor) {
        this.javaSrcOptions = soyJavaSrcOptions;
        this.computableAsJavaExprsVisitor = isComputableAsJavaExprsVisitor;
    }

    @Override
    protected void setup() {
        this.resultStack = new ArrayDeque<Boolean>();
    }

    @Override
    protected Boolean getResult() {
        return this.resultStack.peek();
    }

    @Override
    protected void visitInternal(CallNode callNode) {
        this.resultStack.push(this.javaSrcOptions.getCodeStyle() == SoyJavaSrcOptions.CodeStyle.CONCAT);
    }

    @Override
    protected void visitInternal(SoyNode soyNode) {
        this.resultStack.push((Boolean)this.computableAsJavaExprsVisitor.exec(soyNode));
    }
}

