/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.codedeps;

import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.internal.AugmentedSoyMapData;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.CollectionData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.internal.base.CharEscapers;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class SoyUtils {
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("(\\r\\n|\\r|\\n)");

    public static SoyData $$getData(CollectionData collectionData, String string) {
        SoyData soyData = collectionData.get(string);
        return soyData != null ? soyData : NullData.INSTANCE;
    }

    public static SoyMapData $$augmentData(SoyMapData soyMapData, SoyMapData soyMapData2) {
        AugmentedSoyMapData augmentedSoyMapData = new AugmentedSoyMapData(soyMapData);
        for (Map.Entry<String, SoyData> entry : soyMapData2.asMap().entrySet()) {
            augmentedSoyMapData.put(entry.getKey(), entry.getValue());
        }
        return augmentedSoyMapData;
    }

    public static String $$escapeHtml(String string) {
        return CharEscapers.asciiHtmlEscaper().escape(string);
    }

    public static String $$escapeJs(String string) {
        return CharEscapers.javascriptEscaper().escape(string);
    }

    public static String $$escapeUri(String string) {
        return CharEscapers.uriEscaper(false).escape(string);
    }

    public static String $$changeNewlineToBr(String string) {
        return NEWLINE_PATTERN.matcher(string).replaceAll("<br>");
    }

    public static String $$insertWordBreaks(String string, int n) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 0;
        for (int i = 0; i < string.length(); i += Character.charCount(n2)) {
            n2 = string.codePointAt(i);
            if (n3 >= n && n2 != 32) {
                stringBuilder.append("<wbr>");
                n3 = 0;
            }
            if (bl) {
                if (n2 == 62) {
                    bl = false;
                }
            } else if (bl2) {
                switch (n2) {
                    case 59: {
                        bl2 = false;
                        ++n3;
                        break;
                    }
                    case 60: {
                        bl2 = false;
                        bl = true;
                        break;
                    }
                    case 32: {
                        bl2 = false;
                        n3 = 0;
                    }
                }
            } else {
                switch (n2) {
                    case 60: {
                        bl = true;
                        break;
                    }
                    case 38: {
                        bl2 = true;
                        break;
                    }
                    case 32: {
                        n3 = 0;
                        break;
                    }
                    default: {
                        ++n3;
                    }
                }
            }
            stringBuilder.appendCodePoint(n2);
        }
        return stringBuilder.toString();
    }

    public static NumberData $$negative(NumberData numberData) {
        if (numberData instanceof IntegerData) {
            return new IntegerData(-numberData.integerValue());
        }
        return new FloatData(-numberData.floatValue());
    }

    public static NumberData $$times(NumberData numberData, NumberData numberData2) {
        if (numberData instanceof IntegerData && numberData2 instanceof IntegerData) {
            return new IntegerData(numberData.integerValue() * numberData2.integerValue());
        }
        return new FloatData(numberData.numberValue() * numberData2.numberValue());
    }

    public static SoyData $$plus(SoyData soyData, SoyData soyData2) {
        if (soyData instanceof IntegerData && soyData2 instanceof IntegerData) {
            return new IntegerData(soyData.integerValue() + soyData2.integerValue());
        }
        if (soyData instanceof StringData || soyData2 instanceof StringData) {
            return new StringData(soyData.toString() + soyData2.toString());
        }
        return new FloatData(soyData.numberValue() + soyData2.numberValue());
    }

    public static NumberData $$minus(NumberData numberData, NumberData numberData2) {
        if (numberData instanceof IntegerData && numberData2 instanceof IntegerData) {
            return new IntegerData(numberData.integerValue() - numberData2.integerValue());
        }
        return new FloatData(numberData.numberValue() - numberData2.numberValue());
    }

    public static BooleanData $$lessThan(NumberData numberData, NumberData numberData2) {
        if (numberData instanceof IntegerData && numberData2 instanceof IntegerData) {
            return new BooleanData(numberData.integerValue() < numberData2.integerValue());
        }
        return new BooleanData(numberData.numberValue() < numberData2.numberValue());
    }

    public static BooleanData $$greaterThan(NumberData numberData, NumberData numberData2) {
        if (numberData instanceof IntegerData && numberData2 instanceof IntegerData) {
            return new BooleanData(numberData.integerValue() > numberData2.integerValue());
        }
        return new BooleanData(numberData.numberValue() > numberData2.numberValue());
    }

    public static BooleanData $$lessThanOrEqual(NumberData numberData, NumberData numberData2) {
        if (numberData instanceof IntegerData && numberData2 instanceof IntegerData) {
            return new BooleanData(numberData.integerValue() <= numberData2.integerValue());
        }
        return new BooleanData(numberData.numberValue() <= numberData2.numberValue());
    }

    public static BooleanData $$greaterThanOrEqual(NumberData numberData, NumberData numberData2) {
        if (numberData instanceof IntegerData && numberData2 instanceof IntegerData) {
            return new BooleanData(numberData.integerValue() >= numberData2.integerValue());
        }
        return new BooleanData(numberData.numberValue() >= numberData2.numberValue());
    }

    public static NumberData $$round(NumberData numberData, @Nullable IntegerData integerData) {
        int n;
        int n2 = n = integerData != null ? integerData.integerValue() : 0;
        if (n == 0) {
            if (numberData instanceof IntegerData) {
                return (IntegerData)numberData;
            }
            return new IntegerData((int)Math.round(numberData.numberValue()));
        }
        if (n > 0) {
            double d = numberData.numberValue();
            double d2 = Math.pow(10.0, n);
            return new FloatData((double)Math.round(d * d2) / d2);
        }
        double d = numberData.numberValue();
        double d3 = Math.pow(10.0, -n);
        return new IntegerData((int)((double)Math.round(d / d3) * d3));
    }

    public static NumberData $$min(NumberData numberData, NumberData numberData2) {
        if (numberData instanceof IntegerData && numberData2 instanceof IntegerData) {
            return new IntegerData(Math.min(numberData.integerValue(), numberData2.integerValue()));
        }
        return new FloatData(Math.min(numberData.numberValue(), numberData2.numberValue()));
    }

    public static NumberData $$max(NumberData numberData, NumberData numberData2) {
        if (numberData instanceof IntegerData && numberData2 instanceof IntegerData) {
            return new IntegerData(Math.max(numberData.integerValue(), numberData2.integerValue()));
        }
        return new FloatData(Math.max(numberData.numberValue(), numberData2.numberValue()));
    }
}

