/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.i18n;

import com.google.template.soy.internal.i18n.BidiFormatter;
import com.google.template.soy.internal.i18n.BidiUtils;
import java.util.EnumMap;

public class SoyBidiUtils {
    private static EnumMap<BidiUtils.Dir, BidiFormatter> bidiFormatterCache = new EnumMap(BidiUtils.Dir.class);

    private SoyBidiUtils() {
    }

    public static int getBidiGlobalDir(String string) {
        boolean bl;
        try {
            bl = string != null && (string.equals("qbi") || BidiUtils.isRtlLanguage(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
        }
        return bl ? -1 : 1;
    }

    public static BidiFormatter getBidiFormatter(int n) {
        BidiUtils.Dir dir = BidiUtils.Dir.valueOf(n);
        BidiFormatter bidiFormatter = bidiFormatterCache.get((Object)dir);
        if (bidiFormatter == null) {
            bidiFormatter = BidiFormatter.getInstance(dir);
            bidiFormatterCache.put(dir, bidiFormatter);
        }
        return bidiFormatter;
    }
}

