/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.i18n;

import java.util.regex.Pattern;

public class BidiUtils {
    private static final Pattern RtlLocalesRe = Pattern.compile("^(ar|dv|he|iw|fa|nqo|ps|sd|ug|ur|yi|.*[-_](Arab|Hebr|Thaa|Nkoo|Tfng))(?!.*[-_](Latn|Cyrl)($|-|_))($|-|_)");
    public static final String RIGHT = "right";
    public static final String LEFT = "left";
    private static final Pattern HtmlSkipRe = Pattern.compile("<[^>]*>|&[^;]+;");
    private static final String ltrChars = "A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02b8\u0300-\u0590\u0800-\u1fff\u2c00-\ufb1c\ufdfe-\ufe6f\ufefd-\uffff";
    private static final String rtlChars = "\u0591-\u07ff\ufb1d-\ufdfd\ufe70-\ufefc";
    private static final Pattern hasAnyLtrRe = Pattern.compile("[A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02b8\u0300-\u0590\u0800-\u1fff\u2c00-\ufb1c\ufdfe-\ufe6f\ufefd-\uffff]");
    private static final Pattern hasAnyRtlRe = Pattern.compile("[\u0591-\u07ff\ufb1d-\ufdfd\ufe70-\ufefc]");
    private static final Pattern firstStrongIsLtrRe = Pattern.compile("^[^\u0591-\u07ff\ufb1d-\ufdfd\ufe70-\ufefc]*[A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02b8\u0300-\u0590\u0800-\u1fff\u2c00-\ufb1c\ufdfe-\ufe6f\ufefd-\uffff]");
    private static final Pattern firstStrongIsRtlRe = Pattern.compile("^[^A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02b8\u0300-\u0590\u0800-\u1fff\u2c00-\ufb1c\ufdfe-\ufe6f\ufefd-\uffff]*[\u0591-\u07ff\ufb1d-\ufdfd\ufe70-\ufefc]");
    private static final Pattern lastStrongIsLtrRe = Pattern.compile("[A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02b8\u0300-\u0590\u0800-\u1fff\u2c00-\ufb1c\ufdfe-\ufe6f\ufefd-\uffff][^\u0591-\u07ff\ufb1d-\ufdfd\ufe70-\ufefc]*$");
    private static final Pattern lastStrongIsRtlRe = Pattern.compile("[\u0591-\u07ff\ufb1d-\ufdfd\ufe70-\ufefc][^A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02b8\u0300-\u0590\u0800-\u1fff\u2c00-\ufb1c\ufdfe-\ufe6f\ufefd-\uffff]*$");
    private static final Pattern wordSeparatorRe = Pattern.compile("\\s+");
    private static final Pattern isRequiredLtrRe = Pattern.compile("^http://.*");
    private static final Pattern hasNumeralsRe = Pattern.compile("\\d");
    private static final float rtlDetectionThreshold = 0.4f;

    private BidiUtils() {
    }

    public static Dir languageDir(String string) {
        return BidiUtils.isRtlLanguage(string) ? Dir.RTL : Dir.LTR;
    }

    public static boolean isRtlLanguage(String string) {
        return string != null && RtlLocalesRe.matcher(string).find();
    }

    static String stripHtmlIfNeeded(String string, boolean bl) {
        return bl ? HtmlSkipRe.matcher(string).replaceAll(" ") : string;
    }

    public static boolean hasAnyLtr(String string, boolean bl) {
        return BidiUtils.hasAnyLtr(BidiUtils.stripHtmlIfNeeded(string, bl));
    }

    public static boolean hasAnyLtr(String string) {
        return hasAnyLtrRe.matcher(string).find();
    }

    public static boolean hasAnyRtl(String string, boolean bl) {
        return BidiUtils.hasAnyRtl(BidiUtils.stripHtmlIfNeeded(string, bl));
    }

    public static boolean hasAnyRtl(String string) {
        return hasAnyRtlRe.matcher(string).find();
    }

    public static boolean startsWithLtr(String string, boolean bl) {
        return BidiUtils.startsWithLtr(BidiUtils.stripHtmlIfNeeded(string, bl));
    }

    public static boolean startsWithLtr(String string) {
        return firstStrongIsLtrRe.matcher(string).lookingAt();
    }

    public static boolean startsWithRtl(String string, boolean bl) {
        return BidiUtils.startsWithRtl(BidiUtils.stripHtmlIfNeeded(string, bl));
    }

    public static boolean startsWithRtl(String string) {
        return firstStrongIsRtlRe.matcher(string).lookingAt();
    }

    public static boolean endsWithLtr(String string, boolean bl) {
        return BidiUtils.endsWithLtr(BidiUtils.stripHtmlIfNeeded(string, bl));
    }

    public static boolean endsWithLtr(String string) {
        return lastStrongIsLtrRe.matcher(string).find();
    }

    public static boolean endsWithRtl(String string, boolean bl) {
        return BidiUtils.endsWithRtl(BidiUtils.stripHtmlIfNeeded(string, bl));
    }

    public static boolean endsWithRtl(String string) {
        return lastStrongIsRtlRe.matcher(string).find();
    }

    public static Dir estimateDirection(String string) {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        String[] stringArray = wordSeparatorRe.split(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (BidiUtils.startsWithRtl(string2)) {
                ++n;
                ++n2;
                continue;
            }
            if (isRequiredLtrRe.matcher(string2).matches()) {
                bl = true;
                continue;
            }
            if (BidiUtils.hasAnyLtr(string2)) {
                ++n2;
                continue;
            }
            if (!hasNumeralsRe.matcher(string2).find()) continue;
            bl = true;
        }
        return n2 == 0 ? (bl ? Dir.LTR : Dir.UNKNOWN) : ((float)n / (float)n2 > 0.4f ? Dir.RTL : Dir.LTR);
    }

    public static Dir estimateDirection(String string, boolean bl) {
        return BidiUtils.estimateDirection(BidiUtils.stripHtmlIfNeeded(string, bl));
    }

    public static final class Format {
        public static final char LRE = '\u202a';
        public static final char RLE = '\u202b';
        public static final char PDF = '\u202c';
        public static final char LRM = '\u200e';
        public static final char RLM = '\u200f';
        public static final String LRM_STRING = Character.toString('\u200e');
        public static final String RLM_STRING = Character.toString('\u200f');

        private Format() {
        }
    }

    public static enum Dir {
        LTR(1),
        UNKNOWN(0),
        RTL(-1);

        public final int ord;

        private Dir(int n2) {
            this.ord = n2;
        }

        public static Dir valueOf(int n) {
            return n > 0 ? LTR : (n < 0 ? RTL : UNKNOWN);
        }

        public static Dir valueOf(boolean bl) {
            return bl ? RTL : LTR;
        }

        public boolean isOppositeTo(Dir dir) {
            return this.ord * dir.ord < 0;
        }
    }
}

