/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.base;

public class UnescapeUtils {
    private UnescapeUtils() {
    }

    public static String unescapeJs(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\\') {
                n = UnescapeUtils.unescapeJsHelper(string, n + 1, stringBuilder);
                continue;
            }
            stringBuilder.append(c);
            ++n;
        }
        return stringBuilder.toString();
    }

    private static int unescapeJsHelper(String string, int n, StringBuilder stringBuilder) {
        if (n >= string.length()) {
            throw new IllegalArgumentException("End-of-string after escape character in [" + string + "]");
        }
        char c = string.charAt(n++);
        switch (c) {
            case 'n': {
                stringBuilder.append('\n');
                break;
            }
            case 'r': {
                stringBuilder.append('\r');
                break;
            }
            case 't': {
                stringBuilder.append('\t');
                break;
            }
            case 'b': {
                stringBuilder.append('\b');
                break;
            }
            case 'f': {
                stringBuilder.append('\f');
                break;
            }
            case '\"': 
            case '\'': 
            case '>': 
            case '\\': {
                stringBuilder.append(c);
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                int n2;
                int n3;
                --n;
                int n4 = n3 = c < '4' ? 3 : 2;
                for (n2 = 1; n2 < n3 && n + n2 < string.length() && UnescapeUtils.isOctal(string.charAt(n + n2)); ++n2) {
                }
                stringBuilder.append((char)Integer.parseInt(string.substring(n, n + n2), 8));
                n += n2;
                break;
            }
            case 'u': 
            case 'x': {
                int n5;
                String string2;
                int n6 = c == 'u' ? 4 : 2;
                try {
                    string2 = string.substring(n, n + n6);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new IllegalArgumentException("Invalid unicode sequence [" + string.substring(n) + "] at index " + n + " in [" + string + "]");
                }
                try {
                    n5 = Integer.parseInt(string2, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Invalid unicode sequence [" + string2 + "] at index " + n + " in [" + string + "]");
                }
                stringBuilder.append((char)n5);
                n += n6;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown escape code [" + c + "] at index " + n + " in [" + string + "]");
            }
        }
        return n;
    }

    private static boolean isOctal(char c) {
        return c >= '0' && c <= '7';
    }
}

