/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.base;

import com.google.common.base.Objects;
import java.util.Comparator;
import javax.annotation.Nullable;

public class Pair<A, B> {
    public final A first;
    public final B second;

    public static <A, B> Pair<A, B> of(@Nullable A a, @Nullable B b) {
        return new Pair<A, B>(a, b);
    }

    public Pair(@Nullable A a, @Nullable B b) {
        this.first = a;
        this.second = b;
    }

    public A getFirst() {
        return this.first;
    }

    public B getSecond() {
        return this.second;
    }

    public static <A extends Comparable, B> Comparator<Pair<A, B>> compareByFirst() {
        return FirstComparator.FIRST_COMPARATOR;
    }

    public static <A, B extends Comparable> Comparator<Pair<A, B>> compareBySecond() {
        return SecondComparator.SECOND_COMPARATOR;
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof Pair) {
            Pair pair = (Pair)object;
            return Objects.equal(this.first, pair.first) && Objects.equal(this.second, pair.second);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.first, this.second});
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ")";
    }

    private static enum SecondComparator implements Comparator<Pair<Object, Comparable>>
    {
        SECOND_COMPARATOR;


        @Override
        public int compare(Pair<Object, Comparable> pair, Pair<Object, Comparable> pair2) {
            return pair.getSecond().compareTo(pair2.getSecond());
        }
    }

    private static enum FirstComparator implements Comparator<Pair<Comparable, Object>>
    {
        FIRST_COMPARATOR;


        @Override
        public int compare(Pair<Comparable, Object> pair, Pair<Comparable, Object> pair2) {
            return pair.getFirst().compareTo(pair2.getFirst());
        }
    }
}

