/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprparse;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.template.soy.exprparse.ExpressionParserConstants;
import com.google.template.soy.exprparse.ExpressionParserTokenManager;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.SimpleCharStream;
import com.google.template.soy.exprparse.Token;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.AbstractPrimitiveNode;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataRefIndexNode;
import com.google.template.soy.exprtree.DataRefKeyNode;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarNode;
import com.google.template.soy.internal.base.UnescapeUtils;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class ExpressionParser
implements ExpressionParserConstants {
    public ExpressionParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[11];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public ExpressionParser(String string) {
        this(new StringReader(string));
    }

    public List<ExprRootNode<ExprNode>> parseExpressionList() throws TokenMgrError, ParseException {
        return this.ExprListInput();
    }

    public ExprRootNode<ExprNode> parseExpression() throws TokenMgrError, ParseException {
        return this.ExprInput();
    }

    public ExprRootNode<VarNode> parseVariable() throws TokenMgrError, ParseException {
        return this.VarInput();
    }

    public ExprRootNode<DataRefNode> parseDataReference() throws TokenMgrError, ParseException {
        return this.DataRefInput();
    }

    public ExprRootNode<GlobalNode> parseGlobal() throws TokenMgrError, ParseException {
        return this.GlobalInput();
    }

    private static final ExprNode.OperatorNode createOperatorNode(String string, int n) {
        try {
            return Operator.of(string, n).getNodeClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            Throwables.propagate((Throwable)exception);
            return null;
        }
    }

    private final ExprNode.PrimitiveNode Primitive() throws ParseException {
        AbstractPrimitiveNode abstractPrimitiveNode;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                this.jj_consume_token(1);
                abstractPrimitiveNode = new NullNode();
                break;
            }
            case 2: {
                Token token = this.jj_consume_token(2);
                abstractPrimitiveNode = new BooleanNode(token.image.equals("true"));
                break;
            }
            case 3: {
                Token token = this.jj_consume_token(3);
                if (token.image.startsWith("0x")) {
                    abstractPrimitiveNode = new IntegerNode(Integer.parseInt(token.image.substring(2), 16));
                    break;
                }
                abstractPrimitiveNode = new IntegerNode(Integer.parseInt(token.image, 10));
                break;
            }
            case 4: {
                Token token = this.jj_consume_token(4);
                abstractPrimitiveNode = new FloatNode(Double.parseDouble(token.image));
                break;
            }
            case 5: {
                Token token = this.jj_consume_token(5);
                String string = token.image.substring(1, token.image.length() - 1);
                abstractPrimitiveNode = new StringNode(UnescapeUtils.unescapeJs(string));
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return abstractPrimitiveNode;
    }

    private final String UnaryOp() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                token = this.jj_consume_token(9);
                break;
            }
            case 8: {
                token = this.jj_consume_token(8);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token.image;
    }

    private final String BinaryOp() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                token = this.jj_consume_token(10);
                break;
            }
            case 8: {
                token = this.jj_consume_token(8);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token.image;
    }

    private final List<ExprRootNode<ExprNode>> ExprListInput() throws ParseException {
        List<ExprNode> list = this.ExprList();
        ArrayList arrayList = Lists.newArrayList();
        for (ExprNode exprNode : list) {
            arrayList.add(new ExprRootNode<ExprNode>(exprNode));
        }
        this.jj_consume_token(0);
        return arrayList;
    }

    private final ExprRootNode<ExprNode> ExprInput() throws ParseException {
        ExprNode exprNode = this.Expr();
        this.jj_consume_token(0);
        return new ExprRootNode<ExprNode>(exprNode);
    }

    private final ExprRootNode<VarNode> VarInput() throws ParseException {
        VarNode varNode = this.Var();
        this.jj_consume_token(0);
        return new ExprRootNode<VarNode>(varNode);
    }

    private final ExprRootNode<DataRefNode> DataRefInput() throws ParseException {
        DataRefNode dataRefNode = this.DataRef();
        this.jj_consume_token(0);
        return new ExprRootNode<DataRefNode>(dataRefNode);
    }

    private final ExprRootNode<GlobalNode> GlobalInput() throws ParseException {
        GlobalNode globalNode = this.Global();
        this.jj_consume_token(0);
        return new ExprRootNode<GlobalNode>(globalNode);
    }

    private final List<ExprNode> ExprList() throws ParseException {
        ArrayList arrayList = Lists.newArrayList();
        ExprNode exprNode = this.Expr();
        arrayList.add(exprNode);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(16);
            exprNode = this.Expr();
            arrayList.add(exprNode);
        }
        return arrayList;
    }

    private final ExprNode Expr() throws ParseException {
        ExprNode exprNode = this.PrecExpr1();
        return exprNode;
    }

    private final ExprNode PrecExpr1() throws ParseException {
        ExprNode exprNode = this.PrecExpr(2);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                ExprNode exprNode2 = this.PrecExpr1();
                this.jj_consume_token(18);
                ExprNode exprNode3 = this.PrecExpr1();
                OperatorNodes.ConditionalOpNode conditionalOpNode = new OperatorNodes.ConditionalOpNode();
                conditionalOpNode.addChild(exprNode);
                conditionalOpNode.addChild(exprNode2);
                conditionalOpNode.addChild(exprNode3);
                exprNode = conditionalOpNode;
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        return exprNode;
    }

    private final ExprNode PrecExpr(int n) throws ParseException {
        ExprNode exprNode = this.Primary();
        while (this.jj_2_1(Integer.MAX_VALUE) && Operator.of(this.getToken((int)1).image, 2).getPrecedence() >= n) {
            String string = this.BinaryOp();
            ExprNode exprNode2 = this.PrecExpr(Operator.of(string, 2).getPrecedence() + 1);
            ExprNode.OperatorNode operatorNode = ExpressionParser.createOperatorNode(string, 2);
            operatorNode.addChild(exprNode);
            operatorNode.addChild(exprNode2);
            exprNode = operatorNode;
        }
        return exprNode;
    }

    private final ExprNode Primary() throws ParseException {
        ExprNode exprNode;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                this.jj_consume_token(19);
                exprNode = this.Expr();
                this.jj_consume_token(20);
                break;
            }
            case 8: 
            case 9: {
                String string = this.UnaryOp();
                ExprNode exprNode2 = this.PrecExpr(Operator.of(string, 1).getPrecedence());
                ExprNode.OperatorNode operatorNode = ExpressionParser.createOperatorNode(string, 1);
                operatorNode.addChild(exprNode2);
                exprNode = operatorNode;
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                if (this.jj_2_2(Integer.MAX_VALUE)) {
                    exprNode = this.FunctionCall();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 12: {
                        exprNode = this.DataRef();
                        break block0;
                    }
                    case 11: {
                        exprNode = this.Global();
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        exprNode = this.Primitive();
                        break block0;
                    }
                }
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return exprNode;
    }

    private final VarNode Var() throws ParseException {
        Token token = this.jj_consume_token(12);
        return new VarNode(token.image.substring(1));
    }

    private final DataRefNode DataRef() throws ParseException {
        DataRefNode dataRefNode;
        block9: {
            dataRefNode = new DataRefNode();
            Token token = this.jj_consume_token(12);
            dataRefNode.addChild(new DataRefKeyNode(token.image.substring(1)));
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: 
                    case 14: 
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: {
                        Token token2 = this.jj_consume_token(13);
                        dataRefNode.addChild(new DataRefKeyNode(token2.image.substring(1)));
                        continue block8;
                    }
                    case 14: {
                        Token token3 = this.jj_consume_token(14);
                        dataRefNode.addChild(new DataRefIndexNode(Integer.parseInt(token3.image.substring(1))));
                        continue block8;
                    }
                    case 21: {
                        this.jj_consume_token(21);
                        ExprNode exprNode = this.Expr();
                        this.jj_consume_token(22);
                        dataRefNode.addChild(exprNode);
                        continue block8;
                    }
                }
                break;
            }
            this.jj_la1[8] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return dataRefNode;
    }

    private final GlobalNode Global() throws ParseException {
        StringBuilder stringBuilder = new StringBuilder();
        Token token = this.jj_consume_token(11);
        stringBuilder.append(token.image);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block3;
                }
            }
            Token token2 = this.jj_consume_token(13);
            stringBuilder.append(token2.image);
        }
        return new GlobalNode(stringBuilder.toString());
    }

    private final FunctionNode FunctionCall() throws ParseException {
        Token token = this.jj_consume_token(11);
        this.jj_consume_token(19);
        List<ExprNode> list = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 19: {
                list = this.ExprList();
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        this.jj_consume_token(20);
        FunctionNode functionNode = new FunctionNode(token.image);
        if (list != null) {
            functionNode.addChildren((List<? extends ExprNode>)list);
        }
        return functionNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    private final boolean jj_3_1() {
        return this.jj_3R_5();
    }

    private final boolean jj_3_2() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_5() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(10)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(8)) {
                return true;
            }
        }
        return false;
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{62, 768, 1280, 65536, 131072, 525056, 6206, 0x206000, 0x206000, 8192, 531262};
    }

    public ExpressionParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public ExpressionParser(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream = new SimpleCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source = new ExpressionParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 11; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, null);
    }

    public void ReInit(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 11; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public ExpressionParser(Reader reader) {
        int n;
        this.jj_input_stream = new SimpleCharStream(reader, 1, 1);
        this.token_source = new ExpressionParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 11; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(Reader reader) {
        int n;
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 11; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public ExpressionParser(ExpressionParserTokenManager expressionParserTokenManager) {
        int n;
        this.token_source = expressionParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 11; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(ExpressionParserTokenManager expressionParserTokenManager) {
        int n;
        this.token_source = expressionParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 11; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            int n3;
            this.jj_expentry = new int[this.jj_endpos];
            for (n3 = 0; n3 < this.jj_endpos; ++n3) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
            }
            n3 = 0;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                n3 = 1;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] == this.jj_expentry[i]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
                break;
            }
            if (n3 == 0) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[23];
        for (n2 = 0; n2 < 23; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 11; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) == 0) continue;
                blArray[n] = true;
            }
        }
        for (n2 = 0; n2 < 23; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            try {
                JJCalls jJCalls = this.jj_2_rtns[i];
                do {
                    if (jJCalls.gen <= this.jj_gen) continue;
                    this.jj_la = jJCalls.arg;
                    this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((jJCalls = jJCalls.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        ExpressionParser.jj_la1_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

