/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.examples;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.SoyModule;
import com.google.template.soy.data.SoyListData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.examples.FeaturesSoyInfo;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.SoyMsgBundleHandler;
import com.google.template.soy.parseinfo.SoyTemplateInfo;
import com.google.template.soy.tofu.SoyTofu;
import com.google.template.soy.xliffmsgplugin.XliffMsgPluginModule;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class FeaturesUsage {
    private static final String USAGE_PREFIX = "Usage:\njava com.google.template.soy.examples.FeaturesUsage [-locale <locale>]\n";
    private static final String XLIFF_RESOURCE_PREFIX = "examples_translated_";
    @Option(name="-locale", usage="The locale to render templates in. The corresponding XLIFF resource examples_translated_<locale>.xlf must exist. If not provided, the messages from the Soy source will be used.")
    private String locale = "";
    private int numExamples = 0;

    private FeaturesUsage() {
    }

    public static void main(String[] stringArray) throws IOException {
        new FeaturesUsage().execMain(stringArray);
    }

    private void execMain(String[] stringArray) throws IOException {
        SoyMsgBundle soyMsgBundle;
        Object object;
        Object object2;
        CmdLineParser cmdLineParser = new CmdLineParser((Object)this);
        cmdLineParser.setUsageWidth(100);
        try {
            cmdLineParser.parseArgument(stringArray);
        }
        catch (CmdLineException cmdLineException) {
            System.err.println("\nError: " + cmdLineException.getMessage() + "\n\n");
            System.err.println(USAGE_PREFIX);
            cmdLineParser.printUsage((OutputStream)System.err);
            System.exit(1);
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{new SoyModule(), new XliffMsgPluginModule()});
        SoyFileSet.Builder builder = (SoyFileSet.Builder)injector.getInstance(SoyFileSet.Builder.class);
        SoyFileSet soyFileSet = builder.add(Resources.getResource((String)"simple.soy")).add(Resources.getResource((String)"features.soy")).setCompileTimeGlobals(Resources.getResource((String)"FeaturesUsage_globals.txt")).build();
        SoyTofu soyTofu = soyFileSet.compileToJavaObj().forNamespace("soy.examples.features");
        if (this.locale.length() > 0) {
            object2 = (SoyMsgBundleHandler)injector.getInstance(SoyMsgBundleHandler.class);
            soyMsgBundle = ((SoyMsgBundleHandler)object2).createFromResource((URL)(object = Resources.getResource((String)(XLIFF_RESOURCE_PREFIX + this.locale + ".xlf"))));
            if (soyMsgBundle.getLocaleString() == null) {
                throw new IOException("Error reading message resource \"examples_translated_" + this.locale + ".xlf\".");
            }
        } else {
            soyMsgBundle = null;
        }
        this.writeExampleHeader("demoComments");
        System.out.println(soyTofu.render(FeaturesSoyInfo.DEMO_COMMENTS, (SoyMapData)null, soyMsgBundle));
        this.writeExampleHeader("demoLineJoining");
        System.out.println(soyTofu.render(FeaturesSoyInfo.DEMO_LINE_JOINING, (SoyMapData)null, soyMsgBundle));
        this.writeExampleHeader("demoRawTextCommands");
        System.out.println(soyTofu.render(FeaturesSoyInfo.DEMO_RAW_TEXT_COMMANDS, (SoyMapData)null, soyMsgBundle));
        this.writeExampleHeader("demoPrint");
        System.out.println(soyTofu.render((SoyTemplateInfo)FeaturesSoyInfo.DEMO_PRINT, new SoyMapData(FeaturesSoyInfo.DEMO_PRINT.BOO, "Boo!", FeaturesSoyInfo.DEMO_PRINT.TWO, 2), soyMsgBundle));
        this.writeExampleHeader("demoPrintDirectives");
        System.out.println(soyTofu.render((SoyTemplateInfo)FeaturesSoyInfo.DEMO_PRINT_DIRECTIVES, (Map<String, ?>)ImmutableMap.of((Object)FeaturesSoyInfo.DEMO_PRINT_DIRECTIVES.LONG_VAR_NAME, (Object)"thisIsSomeRidiculouslyLongVariableName", (Object)FeaturesSoyInfo.DEMO_PRINT_DIRECTIVES.ELEMENT_ID, (Object)"my_element_id", (Object)FeaturesSoyInfo.DEMO_PRINT_DIRECTIVES.CSS_CLASS, (Object)"my_css_class"), soyMsgBundle));
        this.writeExampleHeader("demoAutoescapeTrue");
        System.out.println(soyTofu.render((SoyTemplateInfo)FeaturesSoyInfo.DEMO_AUTOESCAPE_TRUE, new SoyMapData(FeaturesSoyInfo.DEMO_AUTOESCAPE_TRUE.ITALIC_HTML, "<i>italic</i>"), soyMsgBundle));
        this.writeExampleHeader("demoAutoescapeFalse");
        System.out.println(soyTofu.render((SoyTemplateInfo)FeaturesSoyInfo.DEMO_AUTOESCAPE_FALSE, new SoyMapData(FeaturesSoyInfo.DEMO_AUTOESCAPE_FALSE.ITALIC_HTML, "<i>italic</i>"), soyMsgBundle));
        this.writeExampleHeader("demoMsg");
        System.out.println(soyTofu.render((SoyTemplateInfo)FeaturesSoyInfo.DEMO_MSG, (Map<String, ?>)ImmutableMap.of((Object)FeaturesSoyInfo.DEMO_MSG.NAME, (Object)"Ed", (Object)FeaturesSoyInfo.DEMO_MSG.LABS_URL, (Object)"http://labs.google.com"), soyMsgBundle));
        this.writeExampleHeader("demoIf");
        System.out.println(soyTofu.render((SoyTemplateInfo)FeaturesSoyInfo.DEMO_IF, new SoyMapData("pi", 3.14159), soyMsgBundle));
        System.out.println(soyTofu.render((SoyTemplateInfo)FeaturesSoyInfo.DEMO_IF, new SoyMapData("pi", 2.71828), soyMsgBundle));
        System.out.println(soyTofu.render((SoyTemplateInfo)FeaturesSoyInfo.DEMO_IF, new SoyMapData("pi", 1.61803), soyMsgBundle));
        this.writeExampleHeader("demoSwitch");
        System.out.println(soyTofu.render((SoyTemplateInfo)FeaturesSoyInfo.DEMO_SWITCH, (Map<String, ?>)ImmutableMap.of((Object)"name", (Object)"Fay"), soyMsgBundle));
        System.out.println(soyTofu.render((SoyTemplateInfo)FeaturesSoyInfo.DEMO_SWITCH, (Map<String, ?>)ImmutableMap.of((Object)"name", (Object)"Go"), soyMsgBundle));
        System.out.println(soyTofu.render((SoyTemplateInfo)FeaturesSoyInfo.DEMO_SWITCH, (Map<String, ?>)ImmutableMap.of((Object)"name", (Object)"Hal"), soyMsgBundle));
        System.out.println(soyTofu.render((SoyTemplateInfo)FeaturesSoyInfo.DEMO_SWITCH, (Map<String, ?>)ImmutableMap.of((Object)"name", (Object)"Ivy"), soyMsgBundle));
        this.writeExampleHeader("demoForeach");
        object2 = new SoyListData();
        ((SoyListData)object2).add(new SoyMapData("name", "Jen", "numWaffles", 1));
        ((SoyListData)object2).add(new SoyMapData("name", "Kai", "numWaffles", 3));
        ((SoyListData)object2).add(new SoyMapData("name", "Lex", "numWaffles", 1));
        ((SoyListData)object2).add(new SoyMapData("name", "Mel", "numWaffles", 2));
        System.out.println(soyTofu.render((SoyTemplateInfo)FeaturesSoyInfo.DEMO_FOREACH, new SoyMapData(FeaturesSoyInfo.DEMO_FOREACH.PERSONS, object2), soyMsgBundle));
        this.writeExampleHeader("demoFor");
        System.out.println(soyTofu.render((SoyTemplateInfo)FeaturesSoyInfo.DEMO_FOR, new SoyMapData(FeaturesSoyInfo.DEMO_FOR.NUM_LINES, 3), soyMsgBundle));
        this.writeExampleHeader("demoCallWithoutParam");
        System.out.println(soyTofu.render((SoyTemplateInfo)FeaturesSoyInfo.DEMO_CALL_WITHOUT_PARAM, new SoyMapData(FeaturesSoyInfo.DEMO_CALL_WITHOUT_PARAM.NAME, "Neo", FeaturesSoyInfo.DEMO_CALL_WITHOUT_PARAM.TRIP_INFO, new SoyMapData("name", "Neo", "destination", "The Matrix")), soyMsgBundle));
        this.writeExampleHeader("demoCallWithParam");
        System.out.println(soyTofu.render((SoyTemplateInfo)FeaturesSoyInfo.DEMO_CALL_WITH_PARAM, (Map<String, ?>)ImmutableMap.of((Object)FeaturesSoyInfo.DEMO_CALL_WITH_PARAM.NAME, (Object)"Oz", (Object)FeaturesSoyInfo.DEMO_CALL_WITH_PARAM.COMPANION_NAME, (Object)"Pip", (Object)FeaturesSoyInfo.DEMO_CALL_WITH_PARAM.DESTINATIONS, (Object)ImmutableList.of((Object)"Gillikin Country", (Object)"Munchkin Country", (Object)"Quadling Country", (Object)"Winkie Country")), soyMsgBundle));
        this.writeExampleHeader("demoCallWithParamBlock");
        System.out.println(soyTofu.render((SoyTemplateInfo)FeaturesSoyInfo.DEMO_CALL_WITH_PARAM_BLOCK, new SoyMapData(FeaturesSoyInfo.DEMO_CALL_WITH_PARAM_BLOCK.NAME, "Quo"), soyMsgBundle));
        this.writeExampleHeader("demoExpressions");
        object = new SoyListData();
        ((SoyListData)object).add(new SoyMapData("name", "Rob", "major", "Physics", "year", 1999));
        ((SoyListData)object).add(new SoyMapData("name", "Sha", "major", "Finance", "year", 1980));
        ((SoyListData)object).add(new SoyMapData("name", "Tim", "major", "Engineering", "year", 2005));
        ((SoyListData)object).add(new SoyMapData("name", "Uma", "major", "Biology", "year", 1972));
        System.out.println(soyTofu.render((SoyTemplateInfo)FeaturesSoyInfo.DEMO_EXPRESSIONS, new SoyMapData(FeaturesSoyInfo.DEMO_EXPRESSIONS.STUDENTS, object, FeaturesSoyInfo.DEMO_EXPRESSIONS.CURRENT_YEAR, 2008), soyMsgBundle));
        this.writeExampleHeader("demoDoubleBraces");
        System.out.println(soyTofu.render((SoyTemplateInfo)FeaturesSoyInfo.DEMO_DOUBLE_BRACES, (Map<String, ?>)ImmutableMap.of((Object)FeaturesSoyInfo.DEMO_DOUBLE_BRACES.SET_NAME, (Object)"prime numbers", (Object)FeaturesSoyInfo.DEMO_DOUBLE_BRACES.SET_MEMBERS, (Object)ImmutableList.of((Object)2, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13)), soyMsgBundle));
        this.writeExampleHeader("demoBidiSupport");
        System.out.println(soyTofu.render((SoyTemplateInfo)FeaturesSoyInfo.DEMO_BIDI_SUPPORT, (Map<String, ?>)ImmutableMap.of((Object)FeaturesSoyInfo.DEMO_BIDI_SUPPORT.TITLE, (Object)"2008: A BiDi Odyssey", (Object)FeaturesSoyInfo.DEMO_BIDI_SUPPORT.AUTHOR, (Object)"John Doe, Esq.", (Object)FeaturesSoyInfo.DEMO_BIDI_SUPPORT.YEAR, (Object)"1973", (Object)FeaturesSoyInfo.DEMO_BIDI_SUPPORT.KEYWORDS, (Object)ImmutableList.of((Object)"Bi(Di)", (Object)"2008 (\u05e9\u05e0\u05d4)", (Object)"2008 (year)")), soyMsgBundle));
    }

    private void writeExampleHeader(String string) {
        ++this.numExamples;
        System.out.println("--------------------------------------------------------------------------------");
        System.out.printf("[%d. %s]\n", this.numExamples, string);
    }
}

