/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internalutils;

import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.StringNode;
import java.util.Map;

public class DataUtils {
    private DataUtils() {
    }

    public static ExprNode.PrimitiveNode convertPrimitiveDataToExpr(PrimitiveData primitiveData) {
        if (primitiveData instanceof StringData) {
            return new StringNode(primitiveData.stringValue());
        }
        if (primitiveData instanceof BooleanData) {
            return new BooleanNode(primitiveData.booleanValue());
        }
        if (primitiveData instanceof IntegerData) {
            return new IntegerNode(primitiveData.integerValue());
        }
        if (primitiveData instanceof FloatData) {
            return new FloatNode(primitiveData.floatValue());
        }
        if (primitiveData instanceof NullData) {
            return new NullNode();
        }
        throw new IllegalArgumentException();
    }

    public static PrimitiveData convertPrimitiveExprToData(ExprNode.PrimitiveNode primitiveNode) {
        if (primitiveNode instanceof StringNode) {
            return new StringData(((StringNode)primitiveNode).getValue());
        }
        if (primitiveNode instanceof BooleanNode) {
            return new BooleanData(((BooleanNode)primitiveNode).getValue());
        }
        if (primitiveNode instanceof IntegerNode) {
            return new IntegerData(((IntegerNode)primitiveNode).getValue());
        }
        if (primitiveNode instanceof FloatNode) {
            return new FloatData(((FloatNode)primitiveNode).getValue());
        }
        if (primitiveNode instanceof NullNode) {
            return NullData.INSTANCE;
        }
        throw new IllegalArgumentException();
    }

    public static ImmutableMap<String, PrimitiveData> convertCompileTimeGlobalsMap(Map<String, ?> map) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            PrimitiveData primitiveData;
            Object obj = entry.getValue();
            boolean bl = true;
            try {
                SoyData soyData = SoyData.createFromExistingData(obj);
                if (!(soyData instanceof PrimitiveData)) {
                    bl = false;
                }
                primitiveData = (PrimitiveData)soyData;
            }
            catch (SoyDataException soyDataException) {
                bl = false;
                primitiveData = null;
            }
            if (!bl) {
                throw new SoySyntaxException("Compile-time globals map contains invalid value: " + obj.toString() + ".");
            }
            builder.put((Object)entry.getKey(), (Object)primitiveData);
        }
        return builder.build();
    }
}

