/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.CollectionData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.StringData;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class SoyListData
extends CollectionData
implements Iterable<SoyData> {
    private final List<SoyData> list = Lists.newArrayList();
    private static final Pattern KEY_PATTERN = Pattern.compile("[0-9]+");

    public SoyListData() {
    }

    public SoyListData(Iterable<?> iterable) {
        this();
        this.add(iterable);
    }

    public SoyListData(Object ... objectArray) {
        this(Arrays.asList(objectArray));
    }

    public List<SoyData> asList() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    public String toString() {
        return "[" + Joiner.on((String)", ").join(this.list) + "]";
    }

    @Override
    public boolean toBoolean() {
        return true;
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    public int length() {
        return this.list.size();
    }

    @Override
    public Iterator<SoyData> iterator() {
        return Collections.unmodifiableList(this.list).iterator();
    }

    private void add(Iterable<?> iterable) {
        for (Object obj : iterable) {
            this.add(SoyData.createFromExistingData(obj));
        }
    }

    public void add(Object ... objectArray) {
        this.add(Arrays.asList(objectArray));
    }

    public void add(SoyData soyData) {
        this.list.add(SoyListData.ensureValidValue(soyData));
    }

    public void add(boolean bl) {
        this.add(new BooleanData(bl));
    }

    public void add(int n) {
        this.add(new IntegerData(n));
    }

    public void add(double d) {
        this.add(new FloatData(d));
    }

    public void add(String string) {
        this.add(new StringData(string));
    }

    public void set(int n, SoyData soyData) {
        if (n == this.list.size()) {
            this.list.add(SoyListData.ensureValidValue(soyData));
        } else {
            this.list.set(n, SoyListData.ensureValidValue(soyData));
        }
    }

    public void set(int n, boolean bl) {
        this.set(n, new BooleanData(bl));
    }

    public void set(int n, int n2) {
        this.set(n, new IntegerData(n2));
    }

    public void set(int n, double d) {
        this.set(n, new FloatData(d));
    }

    public void set(int n, String string) {
        this.set(n, new StringData(string));
    }

    public void remove(int n) {
        this.list.remove(n);
    }

    public SoyData get(int n) {
        try {
            return this.list.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public SoyMapData getMapData(int n) {
        return (SoyMapData)this.get(n);
    }

    public SoyListData getListData(int n) {
        return (SoyListData)this.get(n);
    }

    public boolean getBoolean(int n) {
        return this.get(n).booleanValue();
    }

    public int getInteger(int n) {
        return this.get(n).integerValue();
    }

    public double getFloat(int n) {
        return this.get(n).floatValue();
    }

    public String getString(int n) {
        return this.get(n).stringValue();
    }

    @Override
    protected void checkKey(String string) throws IllegalArgumentException {
        if (!KEY_PATTERN.matcher(string).matches()) {
            throw new IllegalArgumentException("Illegal data key '" + string + "' for list data.");
        }
    }

    @Override
    protected void putSingle(String string, SoyData soyData) {
        this.set(Integer.parseInt(string), soyData);
    }

    @Override
    protected void removeSingle(String string) {
        this.remove(Integer.parseInt(string));
    }

    @Override
    protected SoyData getSingle(String string) {
        return this.get(Integer.parseInt(string));
    }
}

