/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.bidifunctions;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunction;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunctionUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.tofu.restricted.SoyTofuFunction;
import com.google.template.soy.tofu.restricted.SoyTofuFunctionUtils;
import java.util.List;
import java.util.Set;

@Singleton
class BidiStartEdgeFunction
implements SoyTofuFunction,
SoyJsSrcFunction,
SoyJavaSrcFunction {
    private final Provider<Integer> bidiGlobalDirProvider;

    @Inject
    BidiStartEdgeFunction(@ApiCallScopeBindingAnnotations.BidiGlobalDir Provider<Integer> provider) {
        this.bidiGlobalDirProvider = provider;
    }

    @Override
    public String getName() {
        return "bidiStartEdge";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)0);
    }

    @Override
    public SoyData computeForTofu(List<SoyData> list) {
        return SoyTofuFunctionUtils.toSoyData((Integer)this.bidiGlobalDirProvider.get() < 0 ? "right" : "left");
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> list) {
        return new JsExpr((Integer)this.bidiGlobalDirProvider.get() < 0 ? "'right'" : "'left'", Integer.MAX_VALUE);
    }

    @Override
    public JavaExpr computeForJavaSrc(List<JavaExpr> list) {
        return SoyJavaSrcFunctionUtils.toStringJavaExpr(JavaCodeUtils.genNewStringData((Integer)this.bidiGlobalDirProvider.get() < 0 ? "\"right\"" : "\"left\""));
    }
}

