/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.bididirectives;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.tofu.restricted.SoyTofuPrintDirective;
import java.util.List;
import java.util.Set;

@Singleton
public class BidiUnicodeWrapDirective
implements SoyTofuPrintDirective,
SoyJsSrcPrintDirective {
    private final Provider<Integer> bidiGlobalDirProvider;

    @Inject
    BidiUnicodeWrapDirective(@ApiCallScopeBindingAnnotations.BidiGlobalDir Provider<Integer> provider) {
        this.bidiGlobalDirProvider = provider;
    }

    @Override
    public String getName() {
        return "|bidiUnicodeWrap";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)0);
    }

    @Override
    public boolean shouldCancelAutoescape() {
        return false;
    }

    @Override
    public String applyForTofu(String string, List<SoyData> list) {
        return SoyBidiUtils.getBidiFormatter((Integer)this.bidiGlobalDirProvider.get()).unicodeWrap(string, true);
    }

    @Override
    public JsExpr applyForJsSrc(JsExpr jsExpr, List<JsExpr> list) {
        return new JsExpr("soy.$$bidiUnicodeWrap(" + this.bidiGlobalDirProvider.get() + ", " + jsExpr.getText() + ")", Integer.MAX_VALUE);
    }
}

