/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunction;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunctionUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsCodeUtils;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.tofu.restricted.SoyTofuFunction;
import com.google.template.soy.tofu.restricted.SoyTofuFunctionUtils;
import java.util.List;
import java.util.Set;

@Singleton
class RoundFunction
implements SoyTofuFunction,
SoyJsSrcFunction,
SoyJavaSrcFunction {
    @Inject
    RoundFunction() {
    }

    @Override
    public String getName() {
        return "round";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1, (Object)2);
    }

    @Override
    public SoyData computeForTofu(List<SoyData> list) {
        int n;
        SoyData soyData = list.get(0);
        int n2 = n = list.size() == 2 ? list.get(1).integerValue() : 0;
        if (n == 0) {
            if (soyData instanceof IntegerData) {
                return SoyTofuFunctionUtils.toSoyData(soyData.integerValue());
            }
            return SoyTofuFunctionUtils.toSoyData((int)Math.round(soyData.numberValue()));
        }
        if (n > 0) {
            double d = soyData.numberValue();
            double d2 = Math.pow(10.0, n);
            return SoyTofuFunctionUtils.toSoyData((double)Math.round(d * d2) / d2);
        }
        double d = soyData.numberValue();
        double d3 = Math.pow(10.0, -n);
        return SoyTofuFunctionUtils.toSoyData((int)((double)Math.round(d / d3) * d3));
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> list) {
        JsExpr jsExpr = list.get(0);
        JsExpr jsExpr2 = list.size() == 2 ? list.get(1) : null;
        int n = 0;
        if (jsExpr2 != null) {
            try {
                n = Integer.parseInt(jsExpr2.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = Integer.MIN_VALUE;
            }
        }
        if (n == 0) {
            return new JsExpr("Math.round(" + jsExpr.getText() + ")", Integer.MAX_VALUE);
        }
        if (n >= 0 && n <= 12 || n == Integer.MIN_VALUE) {
            String string = n >= 0 && n <= 12 ? "1" + "000000000000".substring(0, n) : "Math.pow(10, " + jsExpr2.getText() + ")";
            JsExpr jsExpr3 = new JsExpr(string, Integer.MAX_VALUE);
            JsExpr jsExpr4 = SoyJsCodeUtils.genJsExprUsingSoySyntax(Operator.TIMES, Lists.newArrayList((Object[])new JsExpr[]{jsExpr, jsExpr3}));
            return new JsExpr("Math.round(" + jsExpr4.getText() + ") / " + jsExpr3.getText(), Operator.DIVIDE_BY.getPrecedence());
        }
        if (n < 0 && n >= -12) {
            String string = "1" + "000000000000".substring(0, -n);
            JsExpr jsExpr5 = new JsExpr(string, Integer.MAX_VALUE);
            JsExpr jsExpr6 = SoyJsCodeUtils.genJsExprUsingSoySyntax(Operator.DIVIDE_BY, Lists.newArrayList((Object[])new JsExpr[]{jsExpr, jsExpr5}));
            return new JsExpr("Math.round(" + jsExpr6.getText() + ") * " + jsExpr5.getText(), Operator.TIMES.getPrecedence());
        }
        throw new IllegalArgumentException("Second argument to round() function is " + n + ", which is too large in magnitude.");
    }

    @Override
    public JavaExpr computeForJavaSrc(List<JavaExpr> list) {
        JavaExpr javaExpr = list.get(0);
        JavaExpr javaExpr2 = list.size() == 2 ? list.get(1) : null;
        String string = javaExpr2 != null ? JavaCodeUtils.genMaybeCast(javaExpr2, IntegerData.class) : "null";
        return SoyJavaSrcFunctionUtils.toNumberJavaExpr(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$round", JavaCodeUtils.genMaybeCast(javaExpr, NumberData.class), string));
    }
}

