/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.template.soy.data.internalutils.DataUtils;
import com.google.template.soy.data.restricted.PrimitiveData;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;

public class SoyUtils {
    private SoyUtils() {
    }

    public static void generateCompileTimeGlobalsFile(Map<String, ?> map, Appendable appendable) throws IOException {
        ImmutableMap<String, PrimitiveData> immutableMap = DataUtils.convertCompileTimeGlobalsMap(map);
        for (Map.Entry entry : immutableMap.entrySet()) {
            String string = DataUtils.convertPrimitiveDataToExpr((PrimitiveData)entry.getValue()).toSourceString();
            appendable.append((CharSequence)entry.getKey()).append(" = ").append(string).append("\n");
        }
    }

    public static void generateCompileTimeGlobalsFile(Map<String, ?> map, File file) throws IOException {
        BufferedWriter bufferedWriter = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        SoyUtils.generateCompileTimeGlobalsFile(map, bufferedWriter);
        bufferedWriter.close();
    }
}

