/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.inject.Injector;
import com.google.template.soy.MainClassUtils;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.javasrc.SoyJavaSrcOptions;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.SoyMsgBundleHandler;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.xliffmsgplugin.XliffMsgPluginModule;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class SoyToJavaSrcCompilerExperimental {
    private static final String USAGE_PREFIX = "Usage:\njava com.google.template.soy.SoyToJavaSrcCompilerExperimental  \\\n     [<flag1> <flag2> ...] --outputPath <outputPath>  \\\n     <soyFile1> <soyFile2> ...\n";
    @Option(name="--inputPrefix", usage="If provided, this path prefix will be prepended to each input file path listed on the command line. This is a literal string prefix, so you'll need to include a trailing slash if necessary.")
    private String inputPrefix = "";
    @Option(name="--outputPath", usage="The path to the output file (if exists, will be overwritten).")
    private String outputPath = "";
    @Option(name="--codeStyle", usage="The code style to use when generating Java code ('stringbuilder' or 'concat').")
    private SoyJavaSrcOptions.CodeStyle codeStyle = SoyJavaSrcOptions.CodeStyle.STRINGBUILDER;
    @Option(name="--messageFilePath", usage="The path to the translated messages file. If not provided, messages from the Soy source are used.")
    private String messageFilePath = "";
    @Option(name="--bidiGlobalDir", usage="The bidi global directionality (ltr=1, rtl=-1) to use when processing bidi functions/directives. Only applicable if your Soy code uses bidi functions/directives. Also note that this flag is usually not necessary if a message file is provided, because in that case the bidi global directionality is simply inferred from the message bundle.")
    private int bidiGlobalDir = 0;
    @Option(name="--cssHandlingScheme", usage="The scheme to use for handling 'css' commands. Specifying 'literal' will cause command text to be inserted as literal text. Specifying 'reference' will cause command text to be evaluated as a data or global reference. This option has no effect if the Soy code does not contain 'css' commands.")
    private String cssHandlingScheme = "literal";
    @Option(name="--compileTimeGlobalsFile", usage="The path to a file containing the mappings for global names to be substituted at compile time. Each line of the file should have the format \"<global_name> = <primitive_data>\" where primitive_data is a valid Soy expression literal for a primitive type (null, boolean, integer, float, or string). Empty lines and lines beginning with \"//\" are ignored. The file should be encoded in UTF-8. If you need to generate a file in this format from Java, consider using the utility SoyUtils.generateCompileTimeGlobalsFile().")
    private String compileTimeGlobalsFile = "";
    @Option(name="--messagePluginModule", usage="Specifies the full class name of a Guice module that binds a SoyMsgPlugin. If not specified, the default is com.google.template.soy.xliffmsgplugin.XliffMsgPluginModule, which binds the XliffMsgPlugin.")
    private String messagePluginModule = XliffMsgPluginModule.class.getName();
    @Option(name="--pluginModules", usage="Specifies the full class names of Guice modules for function plugins and print directive plugins (comma-delimited list).")
    private String pluginModules = "";
    @Argument
    private List<String> arguments = Lists.newArrayList();

    private SoyToJavaSrcCompilerExperimental() {
    }

    public static void main(String[] stringArray) throws IOException, SoySyntaxException {
        new SoyToJavaSrcCompilerExperimental().execMain(stringArray);
    }

    /*
     * WARNING - void declaration
     */
    private void execMain(String[] stringArray) throws IOException, SoySyntaxException {
        void var7_10;
        Object object;
        CmdLineParser cmdLineParser = MainClassUtils.parseFlags(this, stringArray, USAGE_PREFIX);
        if (this.arguments.size() == 0) {
            MainClassUtils.exitWithError("Must provide list of Soy files.", cmdLineParser, USAGE_PREFIX);
        }
        Injector injector = MainClassUtils.createInjector(this.messagePluginModule, this.pluginModules);
        SoyJavaSrcOptions soyJavaSrcOptions = new SoyJavaSrcOptions();
        soyJavaSrcOptions.setCodeStyle(this.codeStyle);
        soyJavaSrcOptions.setBidiGlobalDir(this.bidiGlobalDir);
        SoyFileSet.Builder builder = (SoyFileSet.Builder)injector.getInstance(SoyFileSet.Builder.class);
        for (String object22 : this.arguments) {
            builder.add(new File(this.inputPrefix + object22));
        }
        builder.setCssHandlingScheme(SoyGeneralOptions.CssHandlingScheme.valueOf(this.cssHandlingScheme.toUpperCase()));
        if (this.compileTimeGlobalsFile.length() > 0) {
            builder.setCompileTimeGlobals(new File(this.compileTimeGlobalsFile));
        }
        SoyFileSet soyFileSet = builder.build();
        Object var7_8 = null;
        if (this.messageFilePath.length() > 0) {
            object = (SoyMsgBundleHandler)injector.getInstance(SoyMsgBundleHandler.class);
            SoyMsgBundle soyMsgBundle = ((SoyMsgBundleHandler)object).createFromFile(new File(this.messageFilePath));
        }
        object = soyFileSet.compileToJavaSrc(soyJavaSrcOptions, (SoyMsgBundle)var7_10);
        if (this.outputPath.length() > 0) {
            Files.write((CharSequence)object, (File)new File(this.outputPath), (Charset)Charsets.UTF_8);
        } else {
            System.out.print((String)object);
        }
    }
}

