/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.template.soy.MainClassUtils;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.SoyModule;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public final class SoyParseInfoGenerator {
    private static final String USAGE_PREFIX = "Usage:\njava com.google.template.soy.SoyParseInfoGenerator  \\\n     [<flag1> <flag2> ...] --outputDirectory <path>  \\\n     --javaPackage <package> --javaClassNameSource <source>  \\\n     <soyFile1> <soyFile2> ...\n";
    @Option(name="--inputPrefix", usage="If provided, this path prefix will be prepended to each input file path listed on the command line. This is a literal string prefix, so you'll need to include a trailing slash if necessary.")
    private String inputPrefix = "";
    @Option(name="--outputDirectory", required=true, usage="[Required] The path to the output directory. If files with the same names already exist at this location, they will be overwritten.")
    private String outputDirectory = "";
    @Option(name="--javaPackage", required=true, usage="[Required] The Java package name to use for the generated classes.")
    private String javaPackage = "";
    @Option(name="--javaClassNameSource", required=true, usage="[Required] The source for the generated class names. Valid values are \"filename\", \"namespace\", and \"generic\". Option \"filename\" turns a Soy file name AaaBbb.soy or aaa_bbb.soy into AaaBbbSoyInfo. Option \"namespace\" turns a namespace aaa.bbb.cccDdd into CccDddSoyInfo (note it only uses the last part of the namespace). Option \"generic\" generates class names such as File1SoyInfo, File2SoyInfo.")
    private String javaClassNameSource = "";
    @Argument
    private List<String> arguments = Lists.newArrayList();

    public static void main(String[] stringArray) throws IOException {
        new SoyParseInfoGenerator().execMain(stringArray);
    }

    private SoyParseInfoGenerator() {
    }

    private void execMain(String[] stringArray) throws IOException, SoySyntaxException {
        CmdLineParser cmdLineParser = MainClassUtils.parseFlags(this, stringArray, USAGE_PREFIX);
        if (this.arguments.size() == 0) {
            MainClassUtils.exitWithError("Must provide list of Soy files.", cmdLineParser, USAGE_PREFIX);
        }
        if (this.outputDirectory.length() == 0) {
            MainClassUtils.exitWithError("Must provide output directory.", cmdLineParser, USAGE_PREFIX);
        }
        if (this.javaPackage.length() == 0) {
            MainClassUtils.exitWithError("Must provide Java package.", cmdLineParser, USAGE_PREFIX);
        }
        if (this.javaClassNameSource.length() == 0) {
            MainClassUtils.exitWithError("Must provide Java class name source.", cmdLineParser, USAGE_PREFIX);
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{new SoyModule()});
        SoyFileSet.Builder builder = (SoyFileSet.Builder)injector.getInstance(SoyFileSet.Builder.class);
        String string = this.inputPrefix;
        for (String immutableMap2 : this.arguments) {
            builder.add(new File(string + immutableMap2));
        }
        SoyFileSet soyFileSet = builder.build();
        ImmutableMap<String, String> immutableMap = soyFileSet.generateParseInfo(this.javaPackage, this.javaClassNameSource);
        for (Map.Entry entry : immutableMap.entrySet()) {
            File file = new File(this.outputDirectory, (String)entry.getKey());
            BaseUtils.ensureDirsExistInPath(file.getPath());
            Files.write((CharSequence)((CharSequence)entry.getValue()), (File)file, (Charset)Charsets.UTF_8);
        }
    }
}

