/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.InputSupplier;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.util.Providers;
import com.google.template.soy.GuiceInitializer;
import com.google.template.soy.base.SoyFileSupplier;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.javasrc.SoyJavaSrcOptions;
import com.google.template.soy.javasrc.internal.JavaSrcMain;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.JsSrcMain;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.SoyMsgBundleHandler;
import com.google.template.soy.msgs.internal.ExtractMsgsVisitor;
import com.google.template.soy.parseinfo.passes.GenerateParseInfoVisitor;
import com.google.template.soy.parsepasses.CheckOverridesVisitor;
import com.google.template.soy.parsepasses.HandleCssCommandVisitor;
import com.google.template.soy.parsepasses.PerformAutoescapeVisitor;
import com.google.template.soy.parsepasses.PrependNamespacesVisitor;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.sharedpasses.AssertSyntaxVersionV2Visitor;
import com.google.template.soy.sharedpasses.CheckSoyDocVisitor;
import com.google.template.soy.sharedpasses.ClearSoyDocStringsVisitor;
import com.google.template.soy.sharedpasses.ReplaceStringPrintNodesVisitor;
import com.google.template.soy.sharedpasses.SubstituteGlobalsVisitor;
import com.google.template.soy.soyparse.SoyFileSetParser;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoytreeUtils;
import com.google.template.soy.tofu.SoyTofu;
import com.google.template.soy.tofu.internal.BaseTofu;
import com.google.template.soy.xliffmsgplugin.XliffMsgPlugin;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class SoyFileSet {
    private static final Provider<SoyMsgBundleHandler> DEFAULT_SOY_MSG_BUNDLE_HANDLER_PROVIDER = Providers.of((Object)new SoyMsgBundleHandler(new XliffMsgPlugin()));
    private Provider<SoyMsgBundleHandler> msgBundleHandlerProvider = DEFAULT_SOY_MSG_BUNDLE_HANDLER_PROVIDER;
    private final BaseTofu.BaseTofuFactory baseTofuFactory;
    private final Provider<JsSrcMain> jsSrcMainProvider;
    private final Provider<JavaSrcMain> javaSrcMainProvider;
    private final PerformAutoescapeVisitor performAutoescapeVisitor;
    private final List<SoyFileSupplier> soyFileSuppliers;
    private final SoyGeneralOptions options;

    @Inject
    SoyFileSet(BaseTofu.BaseTofuFactory baseTofuFactory, Provider<JsSrcMain> provider, Provider<JavaSrcMain> provider2, PerformAutoescapeVisitor performAutoescapeVisitor, @Assisted List<SoyFileSupplier> list, @Assisted SoyGeneralOptions soyGeneralOptions) {
        this.baseTofuFactory = baseTofuFactory;
        this.jsSrcMainProvider = provider;
        this.javaSrcMainProvider = provider2;
        this.performAutoescapeVisitor = performAutoescapeVisitor;
        Preconditions.checkArgument((list.size() > 0 ? 1 : 0) != 0, (Object)"Must have non-zero number of input Soy files.");
        this.soyFileSuppliers = list;
        this.options = soyGeneralOptions;
    }

    @Inject(optional=true)
    void setMsgBundleHandlerProvider(Provider<SoyMsgBundleHandler> provider) {
        this.msgBundleHandlerProvider = provider;
    }

    @VisibleForTesting
    List<SoyFileSupplier> getSoyFileSuppliersForTesting() {
        return this.soyFileSuppliers;
    }

    @VisibleForTesting
    SoyGeneralOptions getOptionsForTesting() {
        return this.options;
    }

    public ImmutableMap<String, String> generateParseInfo(String string, String string2) throws SoySyntaxException {
        SoyFileSetNode soyFileSetNode = this.parse();
        new AssertSyntaxVersionV2Visitor().exec(soyFileSetNode);
        new CheckSoyDocVisitor(true).exec(soyFileSetNode);
        return (ImmutableMap)new GenerateParseInfoVisitor(string, string2).exec(soyFileSetNode);
    }

    public SoyMsgBundle extractMsgs() throws SoySyntaxException {
        SoyFileSetNode soyFileSetNode = this.parse();
        return (SoyMsgBundle)new ExtractMsgsVisitor().exec(soyFileSetNode);
    }

    public SoyTofu compileToJavaObj() throws SoySyntaxException {
        SoyFileSetNode soyFileSetNode = this.parse();
        new AssertSyntaxVersionV2Visitor().exec(soyFileSetNode);
        new CheckSoyDocVisitor(true).exec(soyFileSetNode);
        SoytreeUtils.visitAllExprs(soyFileSetNode, new SubstituteGlobalsVisitor((Map<String, PrimitiveData>)this.options.getCompileTimeGlobals(), true));
        new ClearSoyDocStringsVisitor().exec(soyFileSetNode);
        return this.baseTofuFactory.create(soyFileSetNode);
    }

    public String compileToJavaSrc(SoyJavaSrcOptions soyJavaSrcOptions, SoyMsgBundle soyMsgBundle) {
        SoyFileSetNode soyFileSetNode = this.parse();
        new AssertSyntaxVersionV2Visitor().exec(soyFileSetNode);
        new CheckSoyDocVisitor(true).exec(soyFileSetNode);
        SoytreeUtils.visitAllExprs(soyFileSetNode, new SubstituteGlobalsVisitor((Map<String, PrimitiveData>)this.options.getCompileTimeGlobals(), true));
        return ((JavaSrcMain)this.javaSrcMainProvider.get()).genJavaSrc(soyFileSetNode, soyJavaSrcOptions, soyMsgBundle);
    }

    public List<String> compileToJsSrc(SoyJsSrcOptions soyJsSrcOptions, @Nullable SoyMsgBundle soyMsgBundle) throws SoySyntaxException {
        SoyFileSetNode soyFileSetNode = this.parse();
        return ((JsSrcMain)this.jsSrcMainProvider.get()).genJsSrc(soyFileSetNode, soyJsSrcOptions, soyMsgBundle);
    }

    void compileToJsSrcFiles(String string, String string2, SoyJsSrcOptions soyJsSrcOptions, List<String> list, @Nullable String string3) throws SoySyntaxException, IOException {
        if (list.size() == 0) {
            SoyFileSetNode soyFileSetNode = this.parse();
            ((JsSrcMain)this.jsSrcMainProvider.get()).genJsFiles(soyFileSetNode, soyJsSrcOptions, null, null, string, string2);
        } else {
            for (String string4 : list) {
                SoyFileSetNode soyFileSetNode = this.parse();
                String string5 = JsSrcUtils.buildFilePath(string3, string4, null, string2);
                SoyMsgBundle soyMsgBundle = ((SoyMsgBundleHandler)this.msgBundleHandlerProvider.get()).createFromFile(new File(string5));
                if (soyMsgBundle.getLocaleString() == null && !string4.startsWith("en")) {
                    throw new IOException("Error opening or reading message file " + string5);
                }
                ((JsSrcMain)this.jsSrcMainProvider.get()).genJsFiles(soyFileSetNode, soyJsSrcOptions, string4, soyMsgBundle, string, string2);
            }
        }
    }

    private SoyFileSetNode parse() throws SoySyntaxException {
        SoyFileSetNode soyFileSetNode = SoyFileSetParser.parseSoyFiles(this.soyFileSuppliers);
        new PrependNamespacesVisitor().exec(soyFileSetNode);
        new CheckOverridesVisitor().exec(soyFileSetNode);
        new HandleCssCommandVisitor(this.options.getCssHandlingScheme()).exec(soyFileSetNode);
        this.performAutoescapeVisitor.exec(soyFileSetNode);
        if (this.options.getCompileTimeGlobals() != null) {
            SoytreeUtils.visitAllExprs(soyFileSetNode, new SubstituteGlobalsVisitor((Map<String, PrimitiveData>)this.options.getCompileTimeGlobals(), false));
        }
        new ReplaceStringPrintNodesVisitor().exec(soyFileSetNode);
        return soyFileSetNode;
    }

    public static final class Builder {
        @Inject
        private static SoyFileSetFactory soyFileSetFactory = null;
        private final ImmutableList.Builder<SoyFileSupplier> listBuilder = ImmutableList.builder();
        private SoyGeneralOptions options;

        @Inject
        public Builder() {
            this(new SoyGeneralOptions());
        }

        public Builder(SoyGeneralOptions soyGeneralOptions) {
            this.options = soyGeneralOptions.clone();
            GuiceInitializer.initializeIfNecessary();
        }

        public SoyFileSet build() {
            return soyFileSetFactory.create((List<SoyFileSupplier>)this.listBuilder.build(), this.options);
        }

        public Builder add(InputSupplier<? extends Reader> inputSupplier, String string) {
            this.listBuilder.add((Object)new SoyFileSupplier(inputSupplier, string));
            return this;
        }

        public Builder add(File file) {
            this.listBuilder.add((Object)new SoyFileSupplier(file));
            return this;
        }

        public Builder add(URL uRL, String string) {
            this.listBuilder.add((Object)new SoyFileSupplier(uRL, string));
            return this;
        }

        public Builder add(URL uRL) {
            this.listBuilder.add((Object)new SoyFileSupplier(uRL));
            return this;
        }

        public Builder add(CharSequence charSequence, String string) {
            this.listBuilder.add((Object)new SoyFileSupplier(charSequence, string));
            return this;
        }

        public Builder setCssHandlingScheme(SoyGeneralOptions.CssHandlingScheme cssHandlingScheme) {
            this.options.setCssHandlingScheme(cssHandlingScheme);
            return this;
        }

        public Builder setCompileTimeGlobals(Map<String, ?> map) {
            this.options.setCompileTimeGlobals(map);
            return this;
        }

        public Builder setCompileTimeGlobals(File file) throws IOException {
            this.options.setCompileTimeGlobals(file);
            return this;
        }

        public Builder setCompileTimeGlobals(URL uRL) throws IOException {
            this.options.setCompileTimeGlobals(uRL);
            return this;
        }
    }

    static interface SoyFileSetFactory {
        public SoyFileSet create(List<SoyFileSupplier> var1, SoyGeneralOptions var2);
    }
}

