/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.org.yaml.snakeyaml;

import com.newrelic.org.yaml.snakeyaml.composer.Composer;
import com.newrelic.org.yaml.snakeyaml.constructor.BaseConstructor;
import com.newrelic.org.yaml.snakeyaml.constructor.Constructor;
import com.newrelic.org.yaml.snakeyaml.error.YAMLException;
import com.newrelic.org.yaml.snakeyaml.parser.ParserImpl;
import com.newrelic.org.yaml.snakeyaml.reader.Reader;
import com.newrelic.org.yaml.snakeyaml.resolver.Resolver;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Loader {
    protected final BaseConstructor constructor;
    protected Resolver resolver;
    private boolean attached = false;

    public Loader(BaseConstructor constructor) {
        this.constructor = constructor;
        this.resolver = new Resolver();
    }

    public Loader() {
        this(new Constructor());
    }

    public Object load(java.io.Reader io) {
        Composer composer = new Composer(new ParserImpl(new Reader(io)), this.resolver);
        this.constructor.setComposer(composer);
        return this.constructor.getSingleData();
    }

    public Iterable<Object> loadAll(java.io.Reader yaml) {
        Composer composer = new Composer(new ParserImpl(new Reader(yaml)), this.resolver);
        this.constructor.setComposer(composer);
        Iterator<Object> result = new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return Loader.this.constructor.checkData();
            }

            @Override
            public Object next() {
                return Loader.this.constructor.getData();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return new YamlIterable(result);
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    void setAttached() {
        if (this.attached) {
            throw new YAMLException("Loader cannot be shared.");
        }
        this.attached = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class YamlIterable
    implements Iterable<Object> {
        private Iterator<Object> iterator;

        public YamlIterable(Iterator<Object> iterator) {
            this.iterator = iterator;
        }

        @Override
        public Iterator<Object> iterator() {
            return this.iterator;
        }
    }
}

