/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.validation;

import com.newrelic.agent.config.Hostname;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;

public class TokenValidation {
    private static final char[] CHAR_FOR_BYTE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String createToken(String key) throws UnknownHostException {
        return TokenValidation.createToken(key, TokenValidation.getSeed());
    }

    public static String createToken(String key, String seed) {
        return TokenValidation.createToken(Hostname.getHostname(), key, seed);
    }

    public static String createToken(String hostName, String key, String seed) {
        if (null == key || null == hostName) {
            return "";
        }
        String hashMe = MessageFormat.format("{0}-{1}-{2}", hostName, key, seed);
        MessageDigest hasher = null;
        try {
            hasher = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not find SHA1 algorithm", e);
        }
        hasher.reset();
        byte[] hashBytes = hasher.digest(hashMe.getBytes());
        char[] hex = new char[hashBytes.length * 2];
        for (int i = 0; i < hashBytes.length; ++i) {
            int aByte = hashBytes[i] & 0xFF;
            int charLoc = i << 1;
            hex[charLoc] = CHAR_FOR_BYTE[aByte >>> 4];
            hex[charLoc + 1] = CHAR_FOR_BYTE[aByte & 0xF];
        }
        return new String(hex);
    }

    public static String getTokenFromEnvironment() {
        return System.getenv("NR_VALIDATE_TOKEN");
    }

    public static String getSeed() throws UnknownHostException {
        String seed = System.getenv("NR_VALIDATE_SEED");
        if (null == seed || "" == seed) {
            try {
                seed = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                seed = "localhost";
            }
        }
        return seed;
    }
}

