/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.agent.Environment;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.util.ServletUtils;

public class TransactionUtils {
    private static final String FORWARD_SLASH = "/";

    private TransactionUtils() {
    }

    public static void setAppNameFromServletContext(Transaction transaction, Object servletContext) throws Exception {
        String appName;
        if (servletContext != null && transaction.isAutoAppNamingEnabled() && transaction.getApplicationName() == null && (appName = TransactionUtils.getAppNameFromServletContext(servletContext)) != null && appName.length() != 0) {
            if (appName.length() > 1 && appName.startsWith(FORWARD_SLASH)) {
                appName = appName.substring(1, appName.length());
            }
            appName = ServiceManagerFactory.getServiceManager().getApplicationNamingService().getApplicationName(appName);
            transaction.setApplicationName(appName);
        }
    }

    private static String getAppNameFromServletContext(Object servletContext) throws Exception {
        String appName = ServletUtils.getServletContextNameFromServletContext(servletContext);
        if (appName == null) {
            appName = ServletUtils.getContextPathFromServletContext(servletContext);
        }
        return appName;
    }

    public static void setServerInfo(Transaction transaction, Object servletContext) throws Exception {
        String serverInfo;
        Environment env = ServiceManagerFactory.getServiceManager().getEnvironmentService().getEnvironment();
        if (!env.isServerInfoSet() && (serverInfo = ServletUtils.getServletInfoFromServletContext(servletContext)) != null) {
            env.setServerInfo(serverInfo);
        }
    }
}

