/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class JspServletTracer
extends DefaultTracer {
    private static final String SERVLET_REQUEST_INTERFACE = "javax.servlet.ServletRequest";
    private static final String ORG_APACHE_JSP = "org.apache.jsp.";
    private final Pattern JSP_PATTERN = Pattern.compile("_jsp$");
    private final Pattern WEB_INF_PATTERN = Pattern.compile("WEB_002dINF");

    public JspServletTracer(PointCut pc, Transaction transaction, ClassMethodSignature sig, Object servlet, Object[] args) {
        super(transaction, sig, servlet);
        Object request = args[0];
        try {
            int statusCode;
            Method getAttrMethod = request.getClass().getClassLoader().loadClass(SERVLET_REQUEST_INTERFACE).getMethod("getAttribute", String.class);
            Object status = getAttrMethod.invoke(request, "javax.servlet.error.status_code");
            int n = statusCode = status == null ? 200 : Integer.parseInt(status.toString());
            if (statusCode >= 400) {
                Object exception = getAttrMethod.invoke(request, "javax.servlet.jsp.jspException");
                transaction.setStatus(statusCode);
                if (exception != null) {
                    transaction.setThrowable((Throwable)exception);
                }
            }
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINER, "Unable to get exception info through request attributes", t);
        }
        try {
            String name = servlet.getClass().getName();
            if (name.startsWith(ORG_APACHE_JSP)) {
                name = name.substring(ORG_APACHE_JSP.length()).replace('.', '/');
                name = this.WEB_INF_PATTERN.matcher(name).replaceFirst("WEB-INF");
            } else {
                int index = name.lastIndexOf(46);
                if (index > 0) {
                    name = name.substring(index + 1);
                }
            }
            name = this.JSP_PATTERN.matcher(name).replaceAll(".jsp");
            String metricName = "Jsp/" + name;
            this.setMetricNameFormat(new SimpleMetricNameFormat(metricName));
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINER, "An error occurred formatting a jsp name : {0}", e.toString());
            this.setMetricNameFormat(new ClassMethodMetricNameFormat(sig, servlet));
        }
    }
}

