/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.MetricSpec;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.normalization.URLNormalizer;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.trace.TransactionTraceService;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.RequestDispatcherTracer;
import com.newrelic.agent.tracers.SkipTracerException;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpResponse;
import com.newrelic.agent.util.ServletUtils;
import com.newrelic.agent.util.StackTraces;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BasicRequestDispatcherTracer
extends DefaultTracer
implements RequestDispatcherTracer {
    private static String SERVLET_EXCEPTION_CLASS_NAME = "javax.servlet.ServletException";
    protected static final String MISSING_SERVER_NAME_PREFIX = "unkown";
    protected static final String REQUEST_X_START_HEADER = "X-Request-Start";
    protected static final String REQUEST_X_QUEUE_START_HEADER = "X-Queue-Start";
    protected static final String REQUEST_X_QUEUE_TIME_HEADER = "X-Queue-Time";
    private static final Pattern REQUEST_X_START_HEADER_PATTERN = Pattern.compile("([^\\s\\/,(t=)]+)? ?t=([0-9]+)", 32);
    private static final Pattern REQUEST_X_QUEUE_HEADER_PATTERN = Pattern.compile("\\s*t=([0-9]+)", 32);
    private String requestURI;
    private HttpRequest request;
    private HttpResponse response;
    protected boolean ignoreApdex = false;
    private String requestXStartHeader;
    private String requestXQueueStartHeader;
    private String requestXQueueTimeHeader;

    public BasicRequestDispatcherTracer(Transaction transaction, ClassMethodSignature sig, Object dispatcher, HttpRequest request, HttpResponse response) {
        super(transaction, sig, dispatcher, new SimpleMetricNameFormat("HttpDispatcher", ClassMethodMetricNameFormat.getMetricName(sig, dispatcher, "HttpDispatcher")));
        this.request = request;
        this.response = response;
        Tracer rootTracer = transaction.getRootTracer();
        if (rootTracer instanceof RequestDispatcherTracer) {
            throw new SkipTracerException();
        }
    }

    public final HttpRequest getRequest() {
        return this.request;
    }

    protected final HttpResponse getResponse() {
        return this.response;
    }

    public final String getRequestURI() {
        if (this.requestURI == null) {
            this.storeRequestURIAndReferrer();
        }
        return this.requestURI;
    }

    public final void setIgnoreApdex(boolean ignore) {
        this.ignoreApdex = ignore;
    }

    private void storeRequestURIAndReferrer() {
        try {
            this.requestURI = URLNormalizer.getUrlBeforeParameters(this.request.getRequestURI());
        }
        catch (Throwable e) {
            Agent.LOG.severe("Error calling requestURI: " + e.getMessage());
            Agent.LOG.log(Level.FINER, e.getMessage(), e);
            this.requestURI = "/unknown";
        }
        try {
            String referer = this.request.getHeader("Referer");
            if (referer != null) {
                this.getTransaction().getParameters().put("request_referer", referer);
            }
        }
        catch (Throwable e) {
            Agent.LOG.fine("Error getting referer: " + e.getMessage());
            Agent.LOG.log(Level.FINER, e.getMessage(), e);
        }
    }

    private void storeRequestHeaders() {
        this.requestXStartHeader = this.getRequestHeader(REQUEST_X_START_HEADER);
        this.requestXQueueStartHeader = this.getRequestHeader(REQUEST_X_QUEUE_START_HEADER);
        this.requestXQueueTimeHeader = this.getRequestHeader(REQUEST_X_QUEUE_TIME_HEADER);
    }

    private String getRequestHeader(String headerName) {
        try {
            String header = this.request.getHeader(headerName);
            if (header != null && Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Got {0} header: {1}", headerName, header);
                Agent.LOG.finer(msg);
            }
            return header;
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Error getting {0} header: {1}", headerName, t.toString());
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.log(Level.FINER, msg, t);
            } else {
                Agent.LOG.fine(msg);
            }
            return null;
        }
    }

    protected final void doFinish(Throwable throwable) {
        try {
            this.noticeFinish(this.request, throwable);
            this.getTransaction().setThrowable(throwable);
            this.recordParameters(this.request);
            this.storeRequestURIAndReferrer();
            this.storeResponseStatus();
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINE, "An error occurred calling noticeFinish() for dispatcher tracer with an exception", e);
        }
        super.doFinish(throwable);
    }

    private void storeResponseStatus() throws Exception {
        block3: {
            try {
                int status = this.response.getResponseStatus();
                this.getTransaction().setStatus(status);
                if (status >= 400) {
                    this.getTransaction().setStatusMessage(this.response.getResponseStatusMessage());
                }
            }
            catch (Exception e) {
                if (this.getTransaction().getStatus() != 0) break block3;
                throw e;
            }
        }
    }

    protected void reset() {
        super.reset();
        this.request = null;
        this.response = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFinish(int opcode, Object returnValue) {
        try {
            block4: {
                try {
                    this.storeRequestHeaders();
                    this.storeRequestURIAndReferrer();
                    this.storeResponseStatus();
                    if (!this.isInteresting()) break block4;
                    this.recordParameters(this.request);
                }
                catch (Exception e) {
                    Agent.LOG.log(Level.FINE, "An exception was thrown in RequestDispatcherTracer.doFinish() : " + e.getLocalizedMessage(), e);
                    Object var5_4 = null;
                    super.doFinish(opcode, returnValue);
                }
            }
            Object var5_3 = null;
            super.doFinish(opcode, returnValue);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            super.doFinish(opcode, returnValue);
            throw throwable;
        }
    }

    private boolean isInteresting() {
        TransactionTraceService transactionTraceService = ServiceManagerFactory.getServiceManager().getTransactionTraceService();
        if (!transactionTraceService.isEnabled()) {
            return false;
        }
        if (this.getDurationInMilliseconds() > this.getTransaction().getTransactionThreshold()) {
            return true;
        }
        return this.getTransaction().getStatus() >= 400;
    }

    protected void noticeFinish(Object request, Throwable throwable) throws Exception {
    }

    private void storeParameterMap(Map parameterMap) {
        ServletUtils.storeParameterMap(parameterMap, this.getTransaction());
    }

    protected final void recordParameters(Object request) {
        if (!this.getTransaction().isIgnore() && ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig().isCaptureParams()) {
            try {
                this.storeParameterMap(this.getRequestParameterMap());
            }
            catch (Throwable e) {
                Agent.LOG.log(Level.FINE, "Unable to capture request parameters", e);
            }
        }
    }

    protected final Map getRequestParameterMap() throws Exception {
        Map params = this.request.getRequestParameterMap(this.getTransaction().getAgentConfig().getIgnoredParams());
        return params;
    }

    protected void doRecordMetrics(StatsEngine statsEngine, TransactionData transactionData) {
        long externalTime = this.recordHeaderMetrics(statsEngine);
        long externalTimeInMilis = TimeUnit.MILLISECONDS.convert(externalTime, TimeUnit.MICROSECONDS);
        this.recordDispatcherMetrics(statsEngine, transactionData, this.ignoreApdex, externalTimeInMilis);
    }

    private long recordHeaderMetrics(StatsEngine statsEngine) {
        long externalTime = this.recordXQueueHeaderMetrics(statsEngine);
        return externalTime += this.recordXRequestStartHeaderMetrics(statsEngine);
    }

    protected long recordXQueueHeaderMetrics(StatsEngine statsEngine) {
        long queueTime = this.getQueueTime();
        if (queueTime > 0L) {
            this.recordQueueTimeMetrics(statsEngine, queueTime);
        }
        return queueTime;
    }

    protected long getQueueTime() {
        long queueTime = this.getQueueTimeFromHeader();
        if (queueTime > 0L) {
            return queueTime;
        }
        long queueStartTime = this.getQueueStartTimeFromHeader();
        if (queueStartTime > 0L) {
            long txStartTime = TimeUnit.MICROSECONDS.convert(this.getTransaction().getStartTime(), TimeUnit.MILLISECONDS);
            queueTime = txStartTime - queueStartTime;
            return Math.max(0L, queueTime);
        }
        return 0L;
    }

    private long getQueueTimeFromHeader() {
        Matcher matcher;
        if (this.requestXQueueTimeHeader != null && (matcher = REQUEST_X_QUEUE_HEADER_PATTERN.matcher(this.requestXQueueTimeHeader)).find()) {
            String queueTime = matcher.group(1);
            try {
                return Long.parseLong(queueTime);
            }
            catch (NumberFormatException e) {
                String msg = MessageFormat.format("Error parsing queue time {0} in {1}: {2}", queueTime, REQUEST_X_QUEUE_TIME_HEADER, this.requestXQueueTimeHeader);
                Agent.LOG.log(Level.FINER, msg, e);
            }
        }
        return 0L;
    }

    private long getQueueStartTimeFromHeader() {
        Matcher matcher;
        if (this.requestXQueueStartHeader != null && (matcher = REQUEST_X_QUEUE_HEADER_PATTERN.matcher(this.requestXQueueStartHeader)).find()) {
            String queueStartTime = matcher.group(1);
            try {
                return Long.parseLong(queueStartTime);
            }
            catch (NumberFormatException e) {
                String msg = MessageFormat.format("Error parsing queue start time {0} in {1}: {2}", queueStartTime, REQUEST_X_QUEUE_START_HEADER, this.requestXQueueStartHeader);
                Agent.LOG.log(Level.FINER, msg, e);
            }
        }
        return 0L;
    }

    private void recordQueueTimeMetrics(StatsEngine statsEngine, long queueTime) {
        MetricSpec spec = MetricSpec.QUEUE_TIME;
        statsEngine.getResponseTimeStats(spec).recordResponseTime(queueTime, TimeUnit.MICROSECONDS);
    }

    protected long recordXRequestStartHeaderMetrics(StatsEngine statsEngine) {
        if (this.requestXStartHeader == null) {
            return 0L;
        }
        long totalServerTime = 0L;
        int index = 0;
        Matcher matcher = REQUEST_X_START_HEADER_PATTERN.matcher(this.requestXStartHeader);
        while (matcher.find()) {
            ++index;
            String serverName = matcher.group(1);
            if (serverName == null || serverName.length() == 0) {
                serverName = MISSING_SERVER_NAME_PREFIX + String.valueOf(index);
            }
            long serverTimeInMicroseconds = 0L;
            String serverTime = matcher.group(2);
            try {
                serverTimeInMicroseconds = Long.parseLong(serverTime);
            }
            catch (NumberFormatException e) {
                String msg = MessageFormat.format("Error parsing server time {0} in {1}: {2}", serverTime, REQUEST_X_START_HEADER, this.requestXStartHeader);
                Agent.LOG.log(Level.FINER, msg, e);
            }
            if (serverTimeInMicroseconds <= 0L) continue;
            this.recordServerTimeMetrics(statsEngine, serverName, serverTimeInMicroseconds);
            totalServerTime += serverTimeInMicroseconds;
        }
        if (totalServerTime > 0L) {
            this.recordAllServerTimeMetrics(statsEngine, totalServerTime);
        }
        return totalServerTime;
    }

    private void recordServerTimeMetrics(StatsEngine statsEngine, String serverName, long serverTime) {
        MetricSpec spec = MetricSpec.lookup("WebFrontend/WebServer/" + serverName);
        statsEngine.getResponseTimeStats(spec).recordResponseTime(serverTime, TimeUnit.MICROSECONDS);
    }

    private void recordAllServerTimeMetrics(StatsEngine statsEngine, long totalServerTime) {
        MetricSpec spec = MetricSpec.WEBFRONTEND_WEBSERVER_ALL;
        statsEngine.getResponseTimeStats(spec).recordResponseTime(totalServerTime, TimeUnit.MICROSECONDS);
    }

    private void recordDispatcherMetrics(StatsEngine statsEngine, TransactionData transactionData, boolean ignoreApdex, long externalTime) {
        String frontendMetricName = transactionData.getBlameMetricName();
        if (frontendMetricName != null) {
            String frontendApdexMetricName;
            if (!ignoreApdex && (frontendApdexMetricName = transactionData.getFrontendApdexMetricName()) != null) {
                IRPMService rpmService = ServiceManagerFactory.getServiceManager().getRPMServiceManager().getRPMService(transactionData.getApplicationName());
                boolean nonFrustratingTx = transactionData.getResponseStatus() < 400 || rpmService.getErrorService().isIgnoredError(transactionData);
                long apdexT = rpmService.getApdexTInMillis();
                if (nonFrustratingTx) {
                    statsEngine.getApdexStats(MetricSpec.APDEX, apdexT).recordApdexResponseTime(this.getDurationInMilliseconds() + externalTime);
                } else {
                    statsEngine.getApdexStats(MetricSpec.APDEX, apdexT).recordApdexFrustrated();
                }
                MetricSpec frontendApdex = MetricSpec.lookup(frontendApdexMetricName);
                if (nonFrustratingTx) {
                    statsEngine.getApdexStats(frontendApdex, apdexT).recordApdexResponseTime(this.getDurationInMilliseconds() + externalTime);
                } else {
                    statsEngine.getApdexStats(frontendApdex, apdexT).recordApdexFrustrated();
                }
            }
            long frontendTime = this.getDuration() - this.getExclusiveDuration();
            statsEngine.getResponseTimeStats(frontendMetricName).recordResponseTime(frontendTime, 0L, TimeUnit.NANOSECONDS);
            statsEngine.getResponseTimeStats(MetricSpec.WEB_TRANSACTION).recordResponseTime(frontendTime, TimeUnit.NANOSECONDS);
        }
    }

    public Throwable getReportError(Throwable throwable) {
        if (throwable != null && SERVLET_EXCEPTION_CLASS_NAME.equals(throwable.getClass().getName())) {
            return StackTraces.getRootCause(throwable);
        }
        return throwable;
    }
}

