/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.tracers.SkipTracerException;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import java.lang.reflect.Method;
import java.util.logging.Level;

public abstract class AbstractHttpRequest
implements HttpRequest {
    private static final String GET_REQUEST_URI_METHOD_NAME = "getRequestURI";
    private static final String HTTP_SERVLET_REQUEST_INTERFACE = "javax.servlet.http.HttpServletRequest";
    private final Object request;
    private Class<?> requestClass;

    public AbstractHttpRequest(Object request) {
        this.request = request;
        try {
            this.requestClass = request.getClass().getClassLoader().loadClass(this.getRequestClassName());
        }
        catch (ClassNotFoundException e) {
            Agent.LOG.log(Level.FINEST, "Unexpected error", e);
            throw new SkipTracerException();
        }
    }

    public AbstractHttpRequest(Object request, Class requestClass) {
        this.request = request;
        this.requestClass = requestClass;
    }

    protected Object getRequest() {
        return this.request;
    }

    public String getRequestURI() throws Exception {
        return (String)this.requestClass.getMethod(this.getRequestURIMethodName(), new Class[0]).invoke(this.request, new Object[0]);
    }

    protected String getRequestClassName() {
        return HTTP_SERVLET_REQUEST_INTERFACE;
    }

    protected String getRequestURIMethodName() {
        return GET_REQUEST_URI_METHOD_NAME;
    }

    public String getHeader(String name) throws Exception {
        Method getHeaderMethod = this.requestClass.getDeclaredMethod("getHeader", String.class);
        getHeaderMethod.setAccessible(true);
        return (String)getHeaderMethod.invoke(this.request, name);
    }
}

